const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    return db.define("cwxsignapi", {
        app_id: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        app_secret: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        app_type: {
            type: DataTypes.BIGINT,
            allowNull: true,
            comment:'应用类型 0无需签约 1两方签 2三方签'
        },
        auth_type: {
            type: DataTypes.BIGINT,
            allowNull: true,
            comment:'认证类型 0无认证 1姓名二要素 2银行卡三要素 3银行卡四要素'
        },
        company_id: {
            type: DataTypes.BIGINT,
            allowNull: true,
        },//需要在后台补充
        ecid: {
            type: DataTypes.BIGINT,
            allowNull: true,
        },
        notify_url:{
          type:DataTypes.STRING,
          allowNull: true
        },
        redirect_url:{
          type:DataTypes.STRING,
          allowNull: true,
        },
        form_field:{
            type:DataTypes.STRING,
            allowNull: true,
        },
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'c_wxsign_api',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}
