const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("epartner", {
    nickName: DataTypes.STRING(20),
    userName: DataTypes.STRING(50),
    mobile: DataTypes.STRING(20),
    partnerUserType: {
      // 合伙人类型 1个人 2合伙人
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerUserType),
      set: function (val) {
        this.setDataValue("partnerUserType", val);
        this.setDataValue("partnerUserTypeName", uiconfig.config.pdict.partnerUserType[val]);
      },
      defaultValue: "1",
    },
    partnerUserTypeName:{
      // 合伙人来源类型名称
      type:DataTypes.STRING(20),
      defaultValue:"个人",
    },

    partnerSourceTypeName:{
      // 合伙人来源类型名称
      type:DataTypes.STRING(20),
      defaultValue:"自然流量",
    },
    partnerSourceType: {
      // 合伙人来源类型 0自然流量 1合伙人上级 2市场人员
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerSourceType),
      set: function (val) {
        this.setDataValue("partnerSourceType", val);
        this.setDataValue("partnerSourceTypeName", uiconfig.config.pdict.partnerSourceType[val]);
      },
      defaultValue: "0",
    },
    sourceId: DataTypes.INTEGER,
    sourcePartnerId: DataTypes.INTEGER,
    user_id: DataTypes.INTEGER,
    partnerTypeName:{
      // 合伙人类型名称
      type:DataTypes.STRING(20),
      defaultValue:"初级",
    },
    partnerType: {
      // 合伙人类型 0初级 1一级 2二级
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerType),
      set: function (val) {
        this.setDataValue("partnerType", val);
        this.setDataValue("partnerTypeName", uiconfig.config.pdict.partnerType[val]);
      },
      defaultValue: "0",
    },
    partnerLevelName:{
      // 合伙人等级名称
      type:DataTypes.STRING(20),
      defaultValue:"一级",
    },
    partnerLevel: {
      // 合伙人等级  1一级 2二级
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerLevel),
      set: function (val) {
        this.setDataValue("partnerLevel", val);
        this.setDataValue("partnerLevelName", uiconfig.config.pdict.partnerLevel[val]);
      },
      defaultValue: "1",
    },
    cityCode: DataTypes.STRING,
    city: DataTypes.STRING(20),
    pcode: DataTypes.STRING(30),
    ccode: DataTypes.STRING(30),
    advNames: DataTypes.STRING,
    intro: DataTypes.STRING,
    subCount: DataTypes.INTEGER,
    dealCount: DataTypes.INTEGER,
    owner_id: DataTypes.INTEGER,
    auditStatusName:{
      // 审核状态名称
      type:DataTypes.STRING(20),
      defaultValue:"待审核",
    },
    auditStatus: {
      // 审核状态 "0":"待审核","1":"审核通过","2":"审核驳回"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.proxyAuditStatus),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.proxyAuditStatus[val]);
      },
      defaultValue: "0",
    },
    audit_id: DataTypes.INTEGER,
    reg_at : DataTypes.DATE,
    isEnabled: {
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_epartner',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}