const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("usereaccount", {
    mobile: DataTypes.STRING,
    userName: DataTypes.STRING,
    personsSign: DataTypes.STRING,
    eaccountid: DataTypes.STRING,
    bankno: DataTypes.STRING(30),
    email: DataTypes.STRING(50),

    // 打零工新增字段
    headUrl: DataTypes.STRING(300),
    sexName: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    sex: {
      type: DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.sex),
      set: function (val) {
        this.setDataValue("sex", val);
        this.setDataValue("sexName", uiconfig.config.pdict.sex[val]);
      },
    },
    identityName: {
      type: DataTypes.STRING(20),
      defaultValue: "",
    },
    identity: {
      type: DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.identityType),
      set: function (val) {
        this.setDataValue("identity", val);
        this.setDataValue("identityName", uiconfig.config.pdict.identityType[val]);
      },
    },

    eduName: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    edu: {
      type: DataTypes.ENUM,
      allowNull: true,
      values: Object.keys(uiconfig.config.pdict.eduType),
      set: function (val) {
        this.setDataValue("edu", val);
        this.setDataValue("eduName", uiconfig.config.pdict.eduType[val]);
      },
    },
    age: DataTypes.INTEGER,
    height: DataTypes.INTEGER,
    adv: DataTypes.STRING(200),
    experience: DataTypes.STRING(200),
    idCardFront: DataTypes.STRING(300),
    idCardBack: DataTypes.STRING(300),
    isPush: {
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
    isGrantAuto: {
      type:DataTypes.BOOLEAN,
      defaultValue: false
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'p_user_eaccount',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}
