const system=require("../../system");
const ServiceBase=require("../sve.base");
class CcashinfoService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(CcashinfoService));

    this.ccashuserDao = system.getObject("db.ccashuserDao");
  }

  async findUnNotifyIds() {
    return await this.dao.findUnNotifyIds();
  }

  async moreIds(id, mchtId, limit) {
    return await this.dao.moreIds(id, mchtId, limit);
  }

  /**
   * fn:根据条件获取对象
   * @param params
   * @returns {Promise<null>}
   *
   * 条件：mchtId ecid
   *
   */
  async getBean(params) {
    try {
      let where = {};
      if(params.mchtId){
        where.mchtId = params.mchtId;
      }
      if(params.outTradeNo){
        where.outTradeNo = params.outTradeNo;
      }
      if(params.id){
        where.id = params.id;
      }
      let bean =  this.dao.model.findOne({
        where:where
      });
      return bean ||null;
    }catch (e) {
      console.log(e);
      return system.getResult(null,`系统错误 错误信息：`+JSON.stringify(e))
    }
    return null;
  }

  /**
   * fn:保存
   * @param params
   * @returns {Promise<void>}
   */
  async save(params){
    if(!params){
      return null;
    }
    try{
      let res = await this.dao.create(params);
      return res;
    }catch (e) {
      console.log(e);
    }
  }

  /**
   * fn:跟新缓存记录
   * @param params
   * @returns {Promise<void>}
   */
  async update(params){
    try{
      console.log(`跟新【${params.id}】参数` + JSON.stringify(params));
      if(!params.id){
        return null;
      }
      let bean = await this.dao.model.findOne({
        where:{
          id:this.trim(params.id)
        }
      });
      if(!bean){
        console.log(`跟新纪录失败 记录【${params.id}】信息不存在 `);
        return ;
      }
      let properties = {
        id: this.trim(params.id)
      };
      if(params.id_name){
        properties.id_name=this.trim(params.id_name)
      }
      if(params.id_no){
        properties.id_no=this.trim(params.id_no)
      }
      if(params.contract_id){
        properties.contract_id=this.trim(params.contract_id)
      }
      await this.dao.update(properties)
      return {code:0,data:null}
    }catch (e) {
      console.log(e);
      return null;
    }

  }

  /**
   * fn:格式化状态
   * @param ccashinfo
   */
  formatStatus(resData,bean){
    if (!bean || !resData) {
      return;
    }
    //判断用户是否提现过  交易状态 00 成功 01 待处理 02 失败
    if(!bean.trade_status){
      if (bean.qrcode_status == 2) {
        resData.redirect_code = -100;
      } else {
        resData.redirect_code = 1; //跳转到认证
      }
    } else{
      resData.redirect_code = 2;//跳转到领取结果
      resData.trade_status = bean.trade_status;
      if (resData.trade_status == "00") {
        resData.amt = system.f2y(bean.amt);
        resData.actual_amt = system.f2y(bean.actual_amt);
      } else if (resData.trade_status == "02") {
        resData.trade_desc = bean.trade_desc;
      } else if (resData.trade_status == "01") {
        resData.amt = system.f2y(bean.amt);
        resData.trade_desc = bean.trade_desc;
      }
    }
  }
}


module.exports=CcashinfoService;
