const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");
const md5 = require("MD5");

class EcontractofflineService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(EcontractofflineService));

        this.etemplateSve = system.getObject("service.etemplateSve");
        this.usereaccountSve = system.getObject("service.usereaccountSve");

    }




    async findSignAccount(mtchId,idNoList,idNameList){
        var sql = [];
        sql.push("SELECT ");
        sql.push("t1.id_no, t1.id_name");
        sql.push("FROM c_econtract_offline t1");
        sql.push("WHERE t1.mchtId IN (:etemplateIds)");
        sql.push("AND t1.`id_no` IN (:idNoList)");
        sql.push("AND t1.`id_name` IN (:idNameList)");

        var list = await this.dao.customQuery(sql.join(" "), {
            etemplateIds: mtchId,
            idNameList: idNameList,
            idNoList: idNoList,
        });
        return list || [];
    }

    trim(o) {
        if (!o) {
            return "";
        }
        return o.toString().trim();
    }

    returnjson(code, msg, data) {
        return {
            code: code,
            msg: msg,
            data: data || null
        }
    }

}

module.exports = EcontractofflineService;
