var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");

var cacheBaseComp = null;
class BusinessmenCtl extends CtlBase {
  constructor() {
    super();
    this.businessmenSve = system.getObject("service.business.businessmenSve");

  }

  async allPage(pobj, pobj2, req) {
    try {

      let condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        order_id: this.trim(pobj.order_id),
        name: this.trim(pobj.name),
        bd_id: this.trim(pobj.bd_id),
        bd_path: this.trim(pobj.bd_path),
        legal_name: this.trim(pobj.legal_name),
        legal_mobile: this.trim(pobj.legal_mobile),
        legal_idcard: this.trim(pobj.legal_idcard),
        credit_code: this.trim(pobj.credit_code)
      }
      return await this.businessmenSve.allPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }


  async myPage(pobj, pobj2, req) {
    try {
      let condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        order_id: this.trim(pobj.order_id),
        name: this.trim(pobj.name),
        bd_path: this.trim(req.loginUser.orgpath),
        legal_name: this.trim(pobj.legal_name),
        legal_mobile: this.trim(pobj.legal_mobile),
        legal_idcard: this.trim(pobj.legal_idcard),
        credit_code: this.trim(pobj.credit_code)
      }
      if (!condition.bd_path) {
        return system.getResult(null, "");
      }
      return await this.businessmenSve.allPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }


  /**
   * 个体户签约
   * @param {*} params
   */
  async signing(pobj, pobj2, req) {
    if (!pobj.hasOwnProperty('credit_code') && !pobj.credit_code) {
      return system.getResult(null, `参数错误 同意社会信用代码不能为空`);
    }
    if (!pobj.hasOwnProperty('cost_rate') || isNaN(pobj.cost_rate)) {
      return system.getResult(null, `参数错误 核定成本费用率不能为空并且必须为数字`);
    }
    if (!pobj.hasOwnProperty('add_value_up_type') && !pobj.add_value_up_type) {
      return system.getResult(null, `参数错误 增值税累计类型不能为空`);
    }
    if (!pobj.hasOwnProperty('tax_up_type')) {
      return system.getResult(null, `参数错误 个税累计类型不能为空`);
    }
    if (!pobj.hasOwnProperty('service_begin_time')) {
      return system.getResult(null, `参数错误 服务开始时间不能为空`);
    }
    if (!pobj.hasOwnProperty('service_end_time')) {
      return system.getResult(null, `参数错误 服务结束时间不能为空`);
    }
    if (!pobj.hasOwnProperty('service_rate') || !pobj.service_rate || isNaN(pobj.service_rate)) {
      return system.getResult(null, `参数错误 服务费比例不能为空并且必须为数字`);
    }
    if (!pobj.hasOwnProperty('tax_rate') || !pobj.tax_rate || isNaN(pobj.tax_rate)) {
      return system.getResult(null, `参数错误 含税价百分比不能为空并且必须为数字`);
    }


    try {
      pobj.service_rate = system.y2f(pobj.service_rate);
      pobj.tax_rate = system.y2f(pobj.tax_rate);
      pobj.cost_rate = system.y2f(pobj.cost_rate);
      return await this.businessmenSve.signing(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 建帐
   * @param {*} params
   */
  async createAccount(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 个体工商户ID不能为空`);
    }
    try {
      return await this.businessmenSve.createAccount(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  // async auditContract(pobj, pobj2, req) {
  //   try {
  //     var id = Number(pobj.id);
  //     var status = Number(pobj.status);
  //     var notes = this.trim(pobj.notes);

  //     return await this.service.auditContract(id, status, notes);
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }

  // async businessmenSign(pobj, pobj2, req) {
  //   var params = {
  //     id: pobj.id,
  //     commonTaxLadder: this.trim(pobj.commonTaxLadder),
  //     commonOtherLadder: this.trim(pobj.commonOtherLadder),
  //     specialTaxLadder: this.trim(pobj.specialTaxLadder),
  //     specialOtherLadder: this.trim(pobj.specialOtherLadder),
  //   }
  //   try {
  //     return await this.service.businessmenSign(params);
  //   } catch (error) {
  //     console.log(error);
  //     return system.getResultFail(500, "接口异常：" + error.message);
  //   }
  // }
}
module.exports = BusinessmenCtl;