var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");


class UserCtl extends CtlBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
    this.redisClient = system.getObject("util.redisClient");
    this.captchaSve = system.getObject("service.common.captchaSve");
  }

  async login(pobj, pobj2, req, res) {
    var loginName = this.trim(pobj.loginName);
    var password = this.trim(pobj.password);
    // var captchaKey = this.trim(pobj.captchaKey);
    // var captchaCode = this.trim(pobj.captchaCode);

    try {
      // var vrs = await this.captchaSve.valid({
      //   key: captchaKey,
      //   code: captchaCode,
      // });
      // if (vrs.status !== 0) {
      //   return vrs;
      // }

      var loginUser = await this.userSve.login({
        ucname: loginName,
        password: password,
      });
      if(loginUser.status != 0) {
        return loginUser;
      }

      loginUser = loginUser.data;

      var xggadminsid = await this.setLogin(loginUser);
      return system.getResultSuccess(xggadminsid);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async setLogin(user) {
    var xggadminsid = "pt_" + uuidv4();
    xggadminsid = "pt_" + "3cb49932-fa02-44f0-90db-9f06fe02e5c7";
    await this.redisClient.setWithEx(xggadminsid, JSON.stringify(user), 60 * 60);
    return xggadminsid;
  }

  async getMenu(qobj, pobj, req) {
    return system.getResultSuccess(req.loginUser.menus);
  }

  /**
   *   添加 
   * @param {*} params 
   */
  async addUser(params, pobj2, req) {
    try {
      var user = {
        saas_id: params.saas_id,
        org_id: Number(params.org_id || 0),
        ucname: this.trim(params.ucname),
        password: this.trim(params.password),
        uctype: Number(params.uctype || 1),
        uctypeId: this.trim(params.uctypeId),
        mobile: this.trim(params.mobile),
        realName: this.trim(params.realName),
        roles: params.roles || [],
      };
      if (!user.ucname) {
        return system.getResult(null, "请填写用户名");
      }
      if (!user.password) {
        return system.getResult(null, "请填写密码");
      }
      if (!user.mobile) {
        return system.getResult(null, "请填写手机号");
      }
      if (!user.realName) {
        return system.getResult(null, "请填写姓名");
      }
      if (user.uctype == 1 && !user.org_id) {
        return system.getResult(null, "请选择用户组织机构");
      }

      if (user.uctype != 1) {
        user.org_id = null;
        user.roles = [];
      }
      return await this.userSve.addUser(user);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   更新
   * @param {*} params 
   */
  async updUser(params, pobj2, req) {
    var user = {
      id: Number(params.id || 0),
      saas_id: params.saas_id,
      org_id: Number(params.org_id || 0),
      uctype: Number(params.uctype || 1),
      uctypeId: this.trim(params.uctypeId),
      mobile: this.trim(params.mobile),
      realName: this.trim(params.realName),
      roles: params.roles || [],
    };

    if (!user.id) {
      return system.getResult(null, "用户不存在");
    }

    if (!user.mobile) {
      return system.getResult(null, "请填写手机号");
    }

    if (!user.realName) {
      return system.getResult(null, "请填写姓名");
    }

    if (user.uctype == 1 && !user.org_id) {
      return system.getResult(null, "请选择用户组织机构");
    }

    if (user.uctype != 1) {
      user.org_id = null;
      user.roles = [];
    }

    try {
      return await this.userSve.updUser(user);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async currentUser(qobj, pobj, req) {
    return system.getResultSuccess(req.loginUser);
  }

  /**
   * 启用禁用
   * @param {*} params 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async enabled(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      params.enabled = Number(params.enabled || 0);
      return await this.userSve.enabled(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async delUser(params, pobj2, req) {
    try {
      return await this.userSve.delUser(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   查询明细
   * @param {*} params 
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.userSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async updPassword(params, pobj2, req) {
    params.password = this.trim(params.password);
    if(!params.password) {
      return system.getResult(null, `请填写密码`);
    }

    try {
      return await this.userSve.updPassword(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params 
   */
  async page(params, pobj2, req) {
    try {
      return await this.userSve.page(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async salesmanList(params, pobj2, req) {
    try {
      params.uctype = 1;
      return await this.userSve.findByRoleCodes(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}
module.exports = UserCtl;