var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class AccessAuthAPI extends APIBase {
   constructor() {
      super();
      this.userSve = system.getObject("service.auth.userSve");
   }

   //不从平台应用列表入口登录时
   //先要调用平台登录接口
   //返回token,利用这个token再去登录某个具体APP
   //会话存储具体APP的用户信息
   //每个前端应用打开时，先检查是否存在token
   //如果存在，就去访问获取用户信息，---调用本接口--即刻

    //进入或登录某个具体应用
    //前提是已经具备了统一管理的账号，并且已经在统一管理账号登录，客户端具备了token
    //进入某个具体应用时，需要指定 x-appkey请求头
    //
  async loginToApp(p,q,req){
    let appkey=req.xctx.appkey;
    
   }
   async getBizUserForBizChance(p,q,req){
      let s= await this.userSve.getBizUserForBizChance(p.clientMobile,p.spName,p.productCatName,p.regionName)
      return system.getResult(s)
   }
   async getBizUserForDelivery(p,q,req){
      let s= await this.userSve.getBizUserForDelivery(p.clientMobile,p.spName,p.productCatName,p.skucode,p.regionName)
      return system.getResult(s)
   }
   classDesc() {
      return {
         groupName: "auth",
         groupDesc: "认证相关的包",
         name: "AccessAuthAPI",
         desc: "关于认证的类",
         exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
      };
   }
   methodDescs() {
      return [
         {
            methodDesc: "生成访问token,访问地址：http://......../api/auth/accessAuth/getAccessKey,访问token需要放置到后续API方法调用的请求头中",
            methodName: "getAccessKey",
            paramdescs: [
               {
                  paramDesc: "访问appkey",
                  paramName: "appkey",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "访问secret",
                  paramName: "secret",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object {accessKey: xxxxxx, app: {xxx:xxx}},注意app,是当前app信息,详细见后面示例"
         },
      ];
   }
   exam() {
      return ``
   }
}
module.exports = AccessAuthAPI;
