var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");


var cacheBaseComp = null;
class AppCtl extends CtlBase {
  constructor() {
    super("common", CtlBase.getServiceName(AppCtl));
    this.userCtl = system.getObject("service.auth.userSve");
    this.comS = system.getObject("service.common.companySve");
  }
  async findAndCountAll(pobj, qobj, req) {
    let comtemp = await this.comS.findById(pobj.company_id)
    pobj.myappstrs = comtemp.appids
    let rtn = await super.findAndCountAll(pobj, qobj, req)
    return rtn
  }
  async findAllApps(p, q, req) {
    var rtns = await this.service.findAllApps(p.userid);
    return system.getResult(rtns);
  }
  async getApp(p, q, req) {
    let app = await this.cacheManager["AppCache"].cache(p.appkey, null);
    return system.getResult({ funcJson: JSON.parse(app.functionJSON) });
  }


  async buildFrontRouter(p, q, req) {
    let appkey = p.appkeyForRoute
    let app = await this.cacheManager["AppCache"].cache(appkey, null);
    let funcJSONOBJ = JSON.parse(app.functionJSON)
    if (!funcJSONOBJ || funcJSONOBJ.length === 0) {
      return system.getResultError("请先建立功能数据")
    }
    let rtn = await this.service.buildFrontRouter(funcJSONOBJ, app.id)
    return system.getResult(rtn)


  }

  async getFuncs(p, q, req) {
    let appkey = p.appkey
    let app = await this.cacheManager["AppCache"].cache(appkey, null);
    return system.getResult({ funcJson: JSON.parse(app.functionJSON) })
    //return system.getResult({funcJson:[]})
  }
  async saveFuncTree(p, q, req) {
    let rtn = await this.service.saveFuncTree(p)
    return system.getResult(rtn)
  }
  async create(pobj, queryobj, req) {
    pobj.creator_id = pobj.userid;//设置创建者
    return super.create(pobj, queryobj, req)
  }
  async update(pobj, queryobj, req) {
    return super.update(pobj, queryobj, req);
  }

  async initNewInstance(pobj, queryobj, req) {
    var rtn = {};
    rtn.appkey = this.getUUID();
    rtn.secret = this.getUUID();
    return system.getResult(rtn);
  }
  async resetPass(pobj, queryobj, req) {
    pobj.password = await super.encryptPasswd(settings.defaultpwd);
    var rtn = this.service.resetPass(pobj);
    return system.getResult(rtn);
  }
  async createAdminUser(pobj, queryobj, req) {
    pobj.password = settings.defaultpwd;
    var rtn = this.service.createAdminUser(pobj);
    return system.getResult(rtn);
  }
  async create(pobj, queryobj, req) {
    //设置创建者，需要同时创建app管理员、默认密码、电话
    pobj.creator_id = pobj.userid;
    //  pobj.password=super.encryptPasswd(settings.defaultpwd);
    //构造默认的应用相关的URL
    pobj.authUrl = settings.protocalPrefix + pobj.domainName + "/auth";
    // pobj.uiconfigUrl = settings.protocalPrefix + pobj.domainName + "/api/meta/config/fetchAppConfig";
    // pobj.opCacheUrl = settings.protocalPrefix + pobj.domainName + "/api/meta/opCache/opCacheData";
    // pobj.notifyCacheCountUrl = settings.protocalPrefix + pobj.domainName + "/api/meta/opCache/recvNotificationForCacheCount";
    var app = await super.create(pobj, queryobj, req);
    return system.getResult(app);
  }
  async fetchApiCallData(pobj, queryobj, req) {
    var curappkey = pobj.curappkey;
    //检索出作为访问时的app呼出调用数据
    var rtn = await this.service.fetchApiCallData(curappkey);
    return system.getResultSuccess(rtn);
  }
  //接受缓存计数通知接口
  async recvNotificationForCacheCount(p, q, req) {
    return this.service.recvNotificationForCacheCount(p);
  }
}
module.exports = AppCtl;
