const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class ChannelCache extends CacheBase {
  constructor() {
    super();
    this.channelDao = system.getObject("db.common.channelDao");
  }
  isdebug() {
    return settings.env == "dev";
  }
  desc() {
    return "缓存本地应用对象";
  }
  prefix() {
    return "g_channel_"
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    const configValue = await this.channelDao.model.findOne(
      {where: { routehost: inputkey},
      include:[{model:this.db.models.pathtomethod,as:"pts"}]
    });
    if (configValue) {
      return JSON.stringify(configValue);
    }
    return null;
  }
}
module.exports = ChannelCache;