const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig=system.getSysConfig();
module.exports = (db, DataTypes) => {
  //定价类型
  return db.define("productprice", {
    sptags:{//交付商标签
      type: DataTypes.STRING,
      allowNull: true,
    },
    channeltags:{//渠道标签
      type: DataTypes.STRING,
      allowNull: true,
    },
    skucode:{//自定义简码
      type: DataTypes.STRING,
      allowNull: true,
    },
    skuname:{//自定义名称
      type: DataTypes.STRING,
      allowNull: true,
    },
    pname:{//产品名称
      type: DataTypes.STRING,
      allowNull: true,
    },
    strategyitems:{//定价策略
      type: DataTypes.STRING,
      allowNull: true,
    },
    lowpriceref:{
      type: DataTypes.DECIMAL(10, 2) ,
      allowNull: true,
      defaultValue:0
    },
    hignpriceref:{
      type: DataTypes.DECIMAL(10, 2) ,
      allowNull: true,
      defaultValue:0
    },
    deliverfile:{
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue:''
    },
    extrafile: {
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue:''
    },//和user的from相同，在注册user时，去创建
    desc: {
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue:''
    },//和user的from
    isEnabled:{
      type:DataTypes.BOOLEAN,
      defaultValue: false
    }
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_productprice',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
