var APIBase = require("../../api.base");
var system = require("../../../system");
var glob = require("glob");
var settings = require("../../../../config/settings");
var cacheBaseComp = null;
class BaseCompAPI extends APIBase {
  constructor() {
    super();
    this.cachsearchesSve = system.getObject("service.common.cachsearchesSve");
  }
  async clearAllCache(pobj, gobj, req) {
    return await this.cachsearchesSve.clearAllCache(pobj);
  }
  async getBaseComp() {
    if (cacheBaseComp) {
      return cacheBaseComp;
    }
    var vuePath = settings.basepath + "/app/front/vues/base";
    var baseComps = [];
    var rs = glob.sync(vuePath + "/**/*.vue");
    if (rs) {
      rs.forEach(function (r) {
        var comp = "";
        if (settings.env == "dev") {
          delete require.cache[r];
          comp = require(r).replace(/\n/g, "");
        } else {
          comp = require(r).replace(/\n/g, "");
        }
        baseComps.push(comp);
      });
    }
    // cacheBaseComp = escape(JSON.stringify(baseComps));
    return system.getResult({ basecom: baseComps });
  }

  exam() {
    return `
    xxxxxxxxx
    yyyyyyyyy
    zzzzzzzzz
    ooooooo
    `;
  }
  classDesc() {
    return {
      groupName: "meta",
      groupDesc: "元数据相关的包",
      name: "BaseCompAPI",
      desc: "关于认证的类",
      exam: "",
    };
  }
  methodDescs() {
    return [
      {
        methodDesc: "baseComp",
        methodName: "baseComp",
        paramdescs: [
          {
            paramDesc: "访问appkey",
            paramName: "appkey",
            paramType: "string",
            defaultValue: "x",
          },
          {
            paramDesc: "访问secret",
            paramName: "secret",
            paramType: "string",
            defaultValue: null,
          }
        ],
        rtnTypeDesc: "xxxx",
        rtnType: "xxx"
      }
    ];
  }

}
module.exports = BaseCompAPI;