const TaskBase=require("../task.base");
var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
class UserBalanceTask extends TaskBase{
  constructor(){
    super(TaskBase.getServiceName(UserBalanceTask));
    this.tradeSve=system.getObject("service.tradeSve");
    this.accountSve=system.getObject("service.accountSve");
    this.accountlogSve=system.getObject("service.accountlogSve");
  }
  async subDoTask(){
    await this.checkUserBalance();
  }
  async checkUserBalance(){
    // console.log("checkUserBalance------------------------------------------------------------");
    var accounts = await this.accountSve.dao.model.findAll({attributes:["id","unionId","baoBalance","renBalance"],raw:true});
    // console.log(accounts);
    // console.log("遍历--------------------------------------------------");
    var that = this;
    for(var i=0;i<accounts.length;i++){
      var sumBao=0;
      var sumRen=0;
      var account = accounts[i];
      var trades = await this.tradeSve.dao.model.findAll({where:{account_id:account.id},raw:true});
      trades.forEach(trade=>{
        if(trade.tradeType=="orderPersonFee" || trade.tradeType=="recommendFee" || trade.tradeType=="cashWithdrawal"
          || trade.tradeType=="gift"
          || trade.tradeType=="consume" || trade.tradeType=="fill" || trade.tradeType=="tmSubDeductCoin"){
          sumBao=(Number(trade.baoAmount)*10000+sumBao*10000)/10000;
          if(trade.tradeType!="fill"){
            sumRen=(Number(trade.renAmount)*10000+sumRen*10000)/10000;
          }
          // console.log(sumBao+"++++++++++++++++"+sumRen);
          // else{
          //   sumRen=Number(trade.renAmount)-sumRen;
          // }
        }
        // "fill": "充值", "consume": "消费", "gift": "赠送", "giftMoney": "红包", "refund": "退款","payment":"付款",
        //               "orderTrade": "订单交易", "orderRefund": "订单退款", "orderPersonFee": "订单个人分润",
        //               "orderPlatformFee": "订单平台分润","recommendFee": "推荐分润", "tmSubDeductCoin": "商标提报宝币扣除",
        //               "cashWithdrawal": "现金提现","platUseFee":"平台使用费","publicExpense":"官费","invoiceTaxes":"税费"
        //宝币：
        //  user: "fill": "充值", "consume": "消费", "gift": "赠送","tmSubDeductCoin": "商标提报宝币扣除",
        //  platform:
        //人民币：
        //  user: "fill": "充值","orderPersonFee": "订单个人分润","recommendFee": "推荐分润","cashWithdrawal": "现金提现",
        //  platform: "orderTrade": "订单交易","orderRefund": "订单退款","orderPlatformFee": "订单平台分润","platUseFee":"平台使用费","publicExpense":"官费","invoiceTaxes":"税费"


      });
      if(sumBao==Number(account.baoBalance) && sumRen==Number(account.renBalance)){
        // console.log(account.id+"---------------------------------success");
      }else{
        console.log(account.id+"+++++"+sumBao+"+++++"+sumRen+"+++++"+account.baoBalance+"+++++"+account.renBalance+"--");
        // var obj={id:account.id,baoBalance:sumBao,renBalance:sumRen};
        // var logObj={
        //   accountId:account.id,accountUnionId:account.unionId,beforeBaoBalance:account.baoBalance,beforeRenBalance:account.renBalance,
        //   afterBaoBalance:sumBao,afterRenBalance:sumRen,logType:"user"
        // };
        // var a = await that.accountSve.db.transaction(async function (t){
        //   var accountUpdate = await that.accountSve.update(obj,t);
        //   var log = await that.accountlogSve.create(logObj,t);
        // });
      }
    }
  }
}
module.exports=UserBalanceTask;
// var task=new UserBalanceTask();
// task.checkUserBalance().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
