const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
class CachSearchesSve {
  constructor() {
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.appDao = system.getObject("db.common.appDao");
    this.authUtils = system.getObject("util.businessManager.authUtils");
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  async buildCacheRtn(pageValues) {
    var ps = pageValues.map(k => {
      var tmpList = k.split("|");
      if (tmpList.length == 2) {
        return { name: tmpList[0], val: tmpList[1], key: k };
      }
    });
    return ps;
  }
  async findAndCountAllCache(obj) {
    const pageNo = obj.pageInfo.pageNo;
    const pageSize = obj.pageInfo.pageSize;
    const limit = pageSize;
    const offset = (pageNo - 1) * pageSize;
    var search_name = obj.search && obj.search.name ? obj.search.name : "";

    var cacheCacheKeyPrefix = "sadd_base_appkeys:" + settings.appKey + "_cachekey";
    if (obj.appid == settings.platformid) {
      var cacheList = await this.cacheManager["MagCache"].getCacheSmembersByKey(cacheCacheKeyPrefix);
      if (search_name) {
        cacheList = cacheList.filter(f => f.indexOf(search_name) >= 0);
      }
      var pageValues = cacheList.slice(offset, offset + limit);
      var kobjs = await this.buildCacheRtn(pageValues);
      var tmpList = { results: { rows: kobjs, count: cacheList.length } };
      return system.getResult(tmpList);
    } else {
      var body = {
        pageInfo: obj.pageInfo,
        search: obj.search
      };
      var tmpList = await this.opOtherAppCache("findAndCountAll", body, obj.opCacheUrl);
      return tmpList;
    }
  }
  async delCache(obj) {
    if (obj.appid == settings.platformid) {
      var keyList = obj.key.split("|");
      if (keyList.length == 2) {
        var cacheCacheKeyPrefix = "sadd_base_appkeys:" + settings.appKey + "_cachekey";
        await this.cacheManager["MagCache"].delCacheBySrem(cacheCacheKeyPrefix, obj.key);
        await this.cacheManager["MagCache"].del(keyList[0]);
        return { status: 0 };
      }
    } else {
      var body = {
        del_cachekey: obj.key
      };
      return await this.opOtherAppCache("delCache", body, obj.opCacheUrl);
    }
  }
  async clearAllCache(obj) {
    if (obj.appid == settings.platformid) {
      await this.cacheManager["MagCache"].clearAll();
      return { status: 0 };
    }
    return await this.opOtherAppCache("clearAllCache", {}, obj.opCacheUrl);
  }
  //app调用次数
  async findAndCountAlldetail(obj) {
    var apicallAccu = await this.cacheManager["ApiAccuCache"].getApiCallAccu(obj);
    var result = { rows: [], count: 0 };
    var keys = await this.cacheManager["MagCache"].keys("api_call_" + appkey + "*");
    var detail = null;
    for (let j = 0; j < keys.length; j++) {
      var d = keys[j];
      var pathdetail = d.substr(d.lastIndexOf("_") + 1, d.length);
      var apicalldetailAccu = await this.cacheManager["ApiCallCountCache"].getApiCallCount(appkey, pathdetail);
      var detail = { "detailPath": d, "detailCount": apicalldetailAccu.callcount };
    }
    result.rows = detail;
  }
  //操作别的应用的缓存
  async opOtherAppCache(action_type, body = null, opCacheUrl) {
    var appData = await this.authUtils.getTokenInfo(settings.appKey, settings.secret);
    if (appData.status != 0) {
      return appData;
    }
    //按照访问token
    const restS = await system.getObject("util.restClient");
    var restResult = await restS.execPostWithAK(
      {
        action_type: action_type,
        body: body
      },
      opCacheUrl, appData.data.accessKey);

    if (restResult && restResult.status == 0) {
      return restResult;
    }
    return system.getResultFail();
  }
}
module.exports = CachSearchesSve;
