const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
var {reqbyget,buildobj} = require("../../../utils/aliClient");
var fs = require('fs');
class TrademarktransactionService extends ServiceBase {
  constructor() {
    super("tm", ServiceBase.getDaoName(TrademarktransactionService));
    this.ossClient = system.getObject("util.ossClient");
  }
  /**
   * 用户获取业务申请实体列表
   * @param {*} pobj 
   */
  async getApplyListByUserAndType(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ApplyType) {
      return system.getResultFail(-103, "申请主体类型不能为空");
    }
    var limit = ab.PageSize ? Number(ab.PageSize) : 10;
    var offset = ab.PageNumber ? (Number(ab.PageNumber) - 1) * limit : 0
    var countObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    var whereObj = { apply_type: ab.ApplyType, user_id: ab.UserId };
    if (ab.ApplyName) {
      whereObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
      countObj["apply_name"] = { [this.db.Op.like]: "%" + ab.ApplyName + "%" };
    }
    if (ab.Domicile) {
      whereObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
      countObj["domicile"] = { [this.db.Op.like]: "%" + ab.Domicile + "%" };
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile"
      ],
      order: [["created_at", 'desc']]
    });
    var result = system.getResultSuccess(list);
    result.totalCount = count;
    return result;

  }
  /**
   * 用户根据业务申请实体获取实体信息以及业务信息
   */
  async getApplyAndSolutionInfo(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.CreditCode) {
      return system.getResultFail(-103, "社会统一信用代码不能为空");
    }
    var applyinfo = await this.dao.model.findOne({
      where: { user_id: ab.UserId, credit_code: ab.CreditCode },
      attributes: [
        "user_id",
        "apply_name",
        "credit_code",
        "apply_type",
        "operator",
        "regist_capital",
        "business_term",
        "establish_time",
        "domicile",
        "ent_type",
        "business_scope"
      ],
      raw: true
    });
    if (!applyinfo || !applyinfo.credit_code) {
      return system.getResultFail(-300, "未知申请实体信息");
    }
    var list = await this.orderProductDao.findByCompanyAndUser(applyinfo.credit_code, ab.UserId);
    // var list = await this.dao.getPaidSolutionByApplyInfo(applyinfo);
    var result = { applyInfo: applyinfo, productList: list };
    return system.getResultSuccess(result);
  }
  /**
   * 获取用户概览信息
   */
  async getOverviewInfoByUser(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.ProductTypeOne) {//产品大类
      return system.getResultFail(-103, "产品大类编码不能为空");
    }
    var productTypeOne = "%/" + ab.ProductTypeOne + "/%"
    // { [this.db.Op.like]: productTypeOne }
    var companyCount = await this.dao.findCount({ where: { apply_type: 1, user_id: ab.UserId } });//公司数量
    var selfEmployedPersonCount = await this.dao.findCount({ where: { apply_type: 2, user_id: ab.UserId } });//个体户数量
    var waitConfirmCount = await this.needInfoDao.findCount({ where: { status: 3, user_id: ab.UserId, consult_type: { [this.db.Op.like]: productTypeOne } } });//待确认方案数量
    var waitReceiveFileOrderCount = await this.orderDeliveryDao.findOverviewCount(150, ab.UserId, ab.ProductTypeOne);//待收文件数量
    // if(ab.ProductTypeOne == "qcfw"){//资质证照
    //   var internetContentProviderCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/icp/",ab.UserId);//icp数量
    //   var electronicDataInterchangeCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/edi/",ab.UserId);//edi数量
    //   var resultObj = {
    //     internetContentProviderCount: internetContentProviderCount, waitConfirmCount: waitConfirmCount, electronicDataInterchangeCount: electronicDataInterchangeCount,
    //     waitReceiveFileOrderCount: waitReceiveFileOrderCount
    //   };
    //   return system.getResult(resultObj);
    // }
    var internetContentProviderCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/icp/", ab.UserId);//icp数量
    var electronicDataInterchangeCount = await this.orderInfoDao.findOrderCountByProductPathCode("/qcfw/edi/", ab.UserId);//edi数量
    // var resultObj = {
    //   internetContentProviderCount: internetContentProviderCount, waitConfirmCount: waitConfirmCount, electronicDataInterchangeCount: electronicDataInterchangeCount,
    //   waitReceiveFileOrderCount: waitReceiveFileOrderCount
    // };
    var resultObj = {
      companyCount: companyCount, waitConfirmCount: waitConfirmCount, selfEmployedPersonCount: selfEmployedPersonCount,
      waitReceiveFileOrderCount: waitReceiveFileOrderCount, internetContentProviderCount: internetContentProviderCount, electronicDataInterchangeCount: electronicDataInterchangeCount
    };
    return system.getResult(resultObj);
  }
  /**
     * @api {post} /tmtransaction/action/trademarktransaction/springBoard 批量发布
     * @apiGroup 标源管理
     * @apiParamExample {json} 请求参数
     * {
          "actionType": "tmBatchUpload",
          "actionBody": {
            "tm": [{
              "code": "123123",
              "name": "商标名字",
              "channel_code": "18",
              "channel_name": "ali",
              "tm_applier": "18",
              "ncl_one_code": "ali",
              "business_quoted_price": "123",
              "platform_quoted_price": "123",
              "pic_url": "123",
              "publish_status_name": "123",
              "publish_status": "audit",
              "tm_group":"123",
              "tm_service_item":"123",
              "tm_introduction":"123",
              "tm_start_day":"123",
              "tm_end_day":"123",
              "contacts":"13911391996",
              "mobile":"13911391996",
              "notes":"13911391996",
              "op_notes":"13911391996",
              "excelName": "商标名字",//上传时的商标名
              "trademark_type":"ordinary",
              "tm_regist_day":"123",
              "tm_ncl_third":"123"
            }]
          }
        }
     * @apiSuccessExample {json} 成功示例:
     * {
            "status": 1,
            "message": "success",
            "data": {
                "tm": [
                    {
                        "id": 175706,
                        "code": "224262441",
                        "name": "阿里",
                        "channel_code": 10,
                        "channel_name": "公司宝",
                        "tm_applier": "公司宝",
                        "ncl_one_code": "31",
                        "business_quoted_price": "12341",
                        "pic_url": null,
                        "publish_status": "audit",
                        "tm_service_item": "",
                        "tm_start_day": null,
                        "tm_end_day": null,
                        "contacts": "1234",
                        "mobile": "1324",
                        "trademark_type_name": "普通商标",
                        "trademark_type": "ordinary",
                        "tm_regist_day": "",
                        "created_at": "2020-09-09T09:05:53.482Z",
                        "updated_at": "2020-09-09T09:05:53.482Z",
                        "version": 0
                    }
                ],
                "successCount": 1,// 成功个数
                "failCount": 0// 失败个数
            },
            "requestId": "a9fb7670-f27b-11ea-8a62-1d06e253dc40"
        }
     * @apiErrorExample {json} 失败示例:
     * {"error": ""}
     */
  async tmBatchUpload(pobj, actionbody) {
    if (!pobj || !actionbody) {
      return system.getResultFail(-101, "actionBody is empty");
    }
    if (!actionbody.tm) {
      return system.getResultFail(-102, "actionBody.tm is empty");
    }
    // console.log("-------------------------")
    // console.log(actionbody.tm)
    let objlist = await this.addbaseinfo(actionbody.tm);
    // console.log(objlist);
    // console.log("-------------------------")
    // 2020 0909 lin 新增功能 查询code是否存在如果价格 高于之前的code 就价格异常
    // count作为插入成功数量
    var count = 0;
    var failCount = 0;
    for (var i = 0; i < objlist.length; i++) {
      // 2020 0914 lin 新增 以下校验，校验规则为上传模版的5个字段
      if(!objlist[i].excelName) {
        objlist[i]["publish_status"] = "fail"
        failCount++;
        continue;
      }
      if(!objlist[i].code) {
        objlist[i]["publish_status"] = "fail"
        objlist[i]["publish_status"] = "fail"
        objlist[i]["fail_reason"] = "没有注册号"
        failCount++;
        continue;
      }
      if(!objlist[i].business_quoted_price) {
        objlist[i]["publish_status"] = "fail"
        objlist[i]["fail_reason"] = "没有平台底价"
        failCount++;
        continue;
      }
      if(!objlist[i].contacts) {
        objlist[i]["publish_status"] = "fail"
        objlist[i]["fail_reason"] = "没有联系人"
        failCount++;
        continue;
      }
      if(!objlist[i].mobile) {
        objlist[i]["publish_status"] = "fail"
        objlist[i]["fail_reason"] = "没有手机号"
        failCount++;
        continue;
      }
      var tmInfo = await this.dao.model.findOne({
        where: {
          channel_code: objlist[i].channel_code,
          code: objlist[i].code,
          // 2020 0914 lin 修改 批传接口新增查询条件
          publish_status: "uppershelf"
        },
        attributes: [
          "id",
          "business_quoted_price"
        ],
        raw: true
      });
      if (tmInfo) {
        if (tmInfo.business_quoted_price < objlist[i].business_quoted_price) {
          objlist[i]["publish_status"] = "fail"
          objlist[i]["fail_reason"] = "价格比现有的高"
          failCount++;
          continue;
        }
      }
      // 2020 0910 lin 新增 platform_quoted_price = business_quoted_price * 1.2 + 1000
      objlist[i].platform_quoted_price = Number(objlist[i].business_quoted_price) * 1.2 + 1000;
      var boo = isNaN(objlist[i].platform_quoted_price);
      if(boo) {
        failCount++;
        objlist[i]["fail_reason"] = "价格格式有误或没有价格"
        continue;
      }
      count++;
    }
    let res = await this.dao.model.bulkCreate(objlist);
    var data = {
      tm: res,
      successCount: count,
      failCount: failCount
    }
    return system.getResultSuccess(data);
  }
  //甄选特价品牌商标的上传
  async tmAddUpload(pobj, actionbody) {
    if (!pobj || !actionbody) {
      return system.getResultFail(-101, "actionBody is empty");
    }
    let objlist = await this.addbaseinfo([actionbody]);
    let res = "ok"
    for (var i = 0; i < objlist.length; i++) {
      // 2020 0910 lin 新增 platform_quoted_price = business_quoted_price * 1.2 + 1000
      objlist[i].platform_quoted_price = Number(objlist[i].business_quoted_price) * 1.2 + 1000;
      if (objlist[i].id)
        await this.dao.model.updateByWhere(objlist[i], {where: {id: objlist[i].id}})
      else
        res = await this.dao.model.create(objlist[i]);
    await this.updateAlistatus([objlist[i].id||res.id])
    }
    var data = res
    return system.getResultSuccess(data);
  }
  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 标原列表
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
      	"actionType": "tmInfo",
      	"actionBody": {
          "channel_code": "18"// 必填 渠道码 从中台权限获取到
          "pageSize":10,// 每页数量
          "pageNumber":4,// 页
          "excelName": "商标名字",// 商标名字 注意这里 name修改为execlName
          "code": "商标号",
          "channel_name": "申请主体"
          "tm_applier":"申请主体"// 注意这里 申请主体由channel_name改为 tm_applier，但channel_name没有删除 以防以后会用
          "stdate":"2020-09-02 11:30:11",// 专用期限 需要同时传参
          "endate":"2020-09-02 11:35:11",
          "tmList":["175672","175673"],
          "publish_status":"fail" // 发布状态
      	}
      }
   * @apiSuccessExample {json} 成功示例:
   * {
          "status": 1,
          "message": "success",
          "data": [
              {
                "id": 209101,
                "pic_url": "http://43.247.184.94:7170/Img/000/224/262/44A/d1cf283e-f9a2-4a6e-9ab5-1ac74f41d281.jpg",
                "excelName": "萌颜",
                "code": "22426244",
                "contacts": "公司宝",
                "mobile": "13333333333",
                "name": "萌颜",
                "trademark_type_name": "普通商标",
                "ncl_one_code": "42",
                "channel_name": "公司宝",
                "tm_applier": "北京联大共享科技有限公司",// 申请主体
                "business_quoted_price": "1000",
                "platform_quoted_price": "2200",
                "tm_start_day": "2018-02-06T00:00:00.000Z",
                "tm_end_day": "2028-02-06T00:00:00.000Z",
                "publish_status_name": "待审",
                "created_at": "2020-09-17T07:09:33.000Z"
              },
              {
                "id": 209102,
                "pic_url": "http://43.247.184.94:7170/Img/000/224/262/44A/d1cf283e-f9a2-4a6e-9ab5-1ac74f41d281.jpg",
                "excelName": "萌颜",
                "code": "22426244",
                "contacts": "公司宝",
                "mobile": "13333333333",
                "name": "萌颜",
                "trademark_type_name": "普通商标",
                "ncl_one_code": "42",
                "channel_name": "公司宝",
                "tm_applier": "北京联大共享科技有限公司",// 申请主体
                "business_quoted_price": "1000",
                "platform_quoted_price": "2200",
                "tm_start_day": "2018-02-06T00:00:00.000Z",
                "tm_end_day": "2028-02-06T00:00:00.000Z",
                "publish_status_name": "待审",
                "created_at": "2020-09-17T07:09:33.000Z"
              }
          ],
          "totalCount": 2,
          "requestId": "f5170ae0-edab-11ea-876c-a369a023378f"
      }
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
  async tmInfo(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-103, "actionBody is empty");
    }
    var ab = pobj.actionBody;
    // 2020 0914 lin 修改 channle_coode为非必填
    // if (!ab.channel_code) {
    //   return system.getResultFail(-104, "渠道码不能为空");
    // }
    var limit = ab.pageSize ? Number(ab.pageSize) : 10;
    var offset = ab.pageNumber ? (Number(ab.pageNumber) - 1) * limit : 0
    // var countObj = { channel_code: ab.channel_code };
    // var whereObj = { channel_code: ab.channel_code };
    var countObj = {  };
    var whereObj = {  };
    if (ab.excelName) {// 商标名称
      whereObj["excelName"] = { [this.db.Op.like]: "%" + ab.name + "%" };
      countObj["excelName"] = { [this.db.Op.like]: "%" + ab.name + "%" };
    }
    if (ab.code) {// 申请号
      whereObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
      countObj["code"] = { [this.db.Op.like]: "%" + ab.code + "%" };
    }
    if (ab.tm_applier) {// 申请主体 2020 0917 lin 修改 查询条件改为tm_applier。但前端的条件字段为channel_name
      whereObj["tm_applier"] = { [this.db.Op.like]: "%" + ab.tm_applier + "%" };
      countObj["tm_applier"] = { [this.db.Op.like]: "%" + ab.tm_applier + "%" };
    }
    if (ab.channel_name) {// 申请主体 2020 0917 lin 新增
      whereObj["channel_name"] = { [this.db.Op.like]: "%" + ab.channel_name + "%" };
      countObj["channel_name"] = { [this.db.Op.like]: "%" + ab.channel_name + "%" };
    }
    if (ab.tm_start_day && ab.tm_end_day) {// 专用期限
      // whereObj["created_at"] = { [this.db.Op.between]: [ab.stdate, ab.endate] };
      // countObj["created_at"] = { [this.db.Op.between]: [ab.stdate, ab.endate] };
      whereObj["tm_start_day"] = { [this.db.Op.gte]: ab.tm_start_day };
      whereObj["tm_end_day"] = { [this.db.Op.lte]: ab.tm_end_day };
      countObj["tm_start_day"] = { [this.db.Op.gte]: ab.tm_start_day };
      countObj["tm_end_day"] = { [this.db.Op.lte]: ab.tm_end_day };
    }
    if (ab.tmList) {// 根据数组查询
      whereObj["id"] = { [this.db.Op.in]: ab.tmList };
      countObj["id"] = { [this.db.Op.in]: ab.tmList };
    }
    if (ab.publish_status) {// publish_status
      whereObj["publish_status"] = ab.publish_status;
      countObj["publish_status"] = ab.publish_status;
    }
    if (ab.TmType) {// publish_status
      whereObj["TmType"] = ab.TmType;
      countObj["TmType"] = ab.TmType;
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "id",
        "pic_url",
        "excelName",
        "code",
        "contacts",//联系人
        "mobile",//联系电话
        "name",//商标名称
        "TmType",
        "ncl_one_code",
        "channel_name",
        "tm_applier",
        "business_quoted_price",
        "platform_quoted_price",
        "tm_start_day",
        "tm_end_day",
        "publish_status",
        "publish_status_name",
        "fail_reason",
        "created_at"
      ],
      order: [["created_at", 'desc']]
    });
    console.log(list);
    var result = system.getResultSuccess(list);
    result.totalCount = count;
    return result;
  }
  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 标原详情
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
      	"actionType": "tmDetail",
      	"actionBody": {
      		"tmId": "175624"// id
      	}
      }
   * @apiSuccessExample {json} 成功示例:
   * {
        "status": 1,
        "message": "success",
        "data": {
            "id": 175624,
            "code": "123123",//唯一码 商标号
            "name": "商标名字",//商标名称
            "channel_code": "18",// 2020 0901 lin 新增 渠道号
            "channel_name": null,// 2020 0901 lin 新增 渠道名字
            "excelName": "123",//上传时的商标名
            "tm_applier": "18",//商标申请主体
            "ncl_one_code": "ali",//商标大类编码
            "business_quoted_price": "123",//商家报价
            "platform_quoted_price": "123",//平台售价
            "pic_url": "123",//商标图样
            "publish_status_name": "审核中",//商标发布状态名称
            "publish_status": "audit",
            "tm_group": "123",//当前群组
            "tm_service_item": "123",//商品/服务项
            "tm_introduction": "123",//商标简介
            "tm_start_day": "0122-12-31T15:54:17.000Z",//商标生效时间
            "tm_end_day": "0122-12-31T15:54:17.000Z",
            "contacts": "13911391996",//联系人
            "mobile": "13911391996",//联系电话
            "notes": "13911391996",//备注 1
            "op_notes": "13911391996",//操作备注  1 
            "trademark_type_name": "普通商标",
            "trademark_type": "ordinary",// 商标类型
            "tm_regist_day": "123",
            "tm_ncl_third": "123",
            "created_at": "2020-09-03T03:08:24.000Z",
            "updated_at": "2020-09-03T03:08:24.000Z",
            "deleted_at": null,
            "version": 0
        },
        "requestId": "164bce10-edbd-11ea-b4a6-c1bbab30b7b2"
      }
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
  async tmDetail(pobj, actionBody) {
    if (!actionBody.tmId) {
      return system.getResultFail(-105, "actionBody.tmId is empty");
    }
    var tmDetail = await this.dao.findById(actionBody.tmId);
    return system.getResultSuccess(tmDetail);
  }

  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 标原批量上下架
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
      	"actionType": "tmStatusUpdate",
      	"actionBody": {
      		"tm":[
            {
              "id":1,
              "code":1,
              "platform_quoted_price":1200
            },{
              "id":2,
              "code":2,
              "platform_quoted_price":1200
            }
          ]
          status:"uppershelf/lowershelf"
      	}
      }
   * @apiSuccessExample {json} 成功示例:
   * {
        "status": 1,
        "message": "success",
        "data": {
            "id": 175624,
            "code": "123123",//唯一码 商标号
            "name": "商标名字",//商标名称
            "channel_code": "18",// 2020 0901 lin 新增 渠道号
            "channel_name": null,// 2020 0901 lin 新增 渠道名字
            "excelName": "123",//上传时的商标名
            "tm_applier": "18",//商标申请主体
            "ncl_one_code": "ali",//商标大类编码
            "business_quoted_price": "123",//商家报价
            "platform_quoted_price": "123",//平台售价
            "pic_url": "123",//商标图样
            "publish_status_name": "审核中",//商标发布状态名称
            "publish_status": "audit",
            "tm_group": "123",//当前群组
            "tm_service_item": "123",//商品/服务项
            "tm_introduction": "123",//商标简介
            "tm_start_day": "0122-12-31T15:54:17.000Z",//商标生效时间
            "tm_end_day": "0122-12-31T15:54:17.000Z",
            "contacts": "13911391996",//联系人
            "mobile": "13911391996",//联系电话
            "notes": "13911391996",//备注 1
            "op_notes": "13911391996",//操作备注  1 
            "trademark_type_name": "普通商标",
            "trademark_type": "ordinary",// 商标类型
            "tm_regist_day": "123",
            "tm_ncl_third": "123",
            "created_at": "2020-09-03T03:08:24.000Z",
            "updated_at": "2020-09-03T03:08:24.000Z",
            "deleted_at": null,
            "version": 0
        },
        "requestId": "164bce10-edbd-11ea-b4a6-c1bbab30b7b2"
      }
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
/*  async tmStatusUpdate(pobj, actionBody) {
    if (!pobj || !pobj.actionBody || !pobj.actionBody.tm) {
      return system.getResultFail(-103, "actionBody is empty");
    }
    if(actionBody.tm.length == 0) {
      return system.getResultFail(-110, "actionBody.tm is empty");
    }
    switch (actionBody.status) {
      // 如果下架 全部下架
      case "lowershelf" :
        for(var i = 0;i <actionBody.tm.length;i++) {
          await this.dao.model.update({publish_status:"lowershelf"},{ where: { id: actionBody.tm[i].id } })
        }
        // 这个方法会把其他字段改为null 不使用了
        // var tmUpdateResult = await this.dao.model.bulkCreate(actionBody.tm,{updateOnDuplicate:true})
        break;
      case "uppershelf":
        var tmUpdateResult = []
        // 如果上架 去查询code相同并上架的标源，价格低于，则上。否失败
        for(var i = 0;i <actionBody.tm.length;i++) {
          // 查处code相同 id不相同 状态为上架的标
          var tmInfo = await this.dao.model.findOne({
            where: { code:actionBody.tm[i].code, publish_status:"uppershelf",[this.db.Op.not]: [{id:[actionBody.tm[i].id]}] },
            attributes: [
              "id",
              "platform_quoted_price"
            ],
            raw: true
          });
          // 如果没有 随意更改
          if(!tmInfo) {
            await this.dao.model.update({publish_status:"uppershelf"},{ where: { id: actionBody.tm[i].id } })
            continue
          }
          // 如果有并 价格低于之前上架的
          if(actionBody.tm[i].platform_quoted_price < tmInfo.platform_quoted_price) {
            //修改之前的为下架
            await this.dao.model.update({publish_status:"lowershelf"},{ where: { id: tmInfo.id } })
            //修改需要上架的
            await this.dao.model.update({publish_status:"uppershelf"},{ where: { id: actionBody.tm[i].id } })
          }
          // 否则失败 暂时不做处理
          // 可以优化的地方：比如已经是想修改的状态 怎么做跳过？其他验证是否完善？
        }
        break;
      case "oversales" :
        for(var i = 0;i <actionBody.tm.length;i++) {
          await this.dao.model.update({publish_status:"oversales"},{ where: { id: actionBody.tm[i].id } })
        }
        // 这个方法会把其他字段改为null 不使用了
        // var tmUpdateResult = await this.dao.model.bulkCreate(actionBody.tm,{updateOnDuplicate:true})
        break;
      default:
        return system.getResultFail(-111, "修改状态错误");
    }
    return system.getResultSuccess(tmUpdateResult);
  }*/

  async tmStatusUpdate(pobj, actionBody) {
    if (!pobj || !pobj.actionBody || !pobj.actionBody.tm) {
      return system.getResultFail(-103, "actionBody is empty");
    }
    if(actionBody.tm.length == 0) {
      return system.getResultFail(-110, "actionBody.tm is empty");
    }
    let ids = []
    let downids = []
    for(let i = 0;i <actionBody.tm.length;i++) {
      ids.push(actionBody.tm[i].id)
    }
    let status
    switch (actionBody.status) {
        // 如果下架 全部下架
      case "lowershelf" :
        status = "FAIL_END"
        break;
      case "uppershelf":
        ids = []
        status = "ON_SALE"
        // 如果上架 去查询code相同并上架的标源，价格低于，则上。否失败
        for(var i = 0;i <actionBody.tm.length;i++) {
          // 查处code相同 id不相同 状态为上架的标
          var tmInfo = await this.dao.model.findOne({
            where: { code:actionBody.tm[i].code, publish_status:"uppershelf",[this.db.Op.not]: [{id:[actionBody.tm[i].id]}] },
            attributes: [
              "id",
              "platform_quoted_price"
            ],
            raw: true
          });
          // 如果没有 随意更改
          if(!tmInfo) {
            ids.push(actionBody.tm[i].id)
          }
          // 如果有并 价格低于之前上架的
          else if(actionBody.tm[i].platform_quoted_price < tmInfo.platform_quoted_price) {
            //修改之前的为下架
            downids.push(tmInfo.id)
            //修改需要上架的
            ids.push(actionBody.tm[i].id)
          }
        }
        break;
      case "oversales" :
        await this.dao.model.update({publish_status:"oversales"},{ where: { id: {$in:ids} } })
        break;
      default:
        return system.getResultFail(-111, "修改状态错误");
    }
    if (ids.length>0)
      this.updateAli(ids,downids,status)
    return system.getResultSuccess();
  }
  async updateAli(ids,downids, status) {
    if (downids.length>0)
      await this.updateAlistatus(downids,"FAIL_END")
    this.updateAlistatus(ids,status)
  }

  async updateAlistatus(ids, status) {
    let res = await this.dao.model.findAll({where: {id: {$in: ids}}})
    for (const item of res) {
      let obj = buildobj(item,status)
      if (obj) {
        let err = await reqbyget({
          action:item.publish_status==="audit"?"UploadTrademarkOnSale":"UpdateTrademarkOnsale",
          reqbody: obj
        })
        await this.sleep()
        if (err){
          item.fail_reason = err
          item.publish_status = "fail"
          item.publish_status_name = "发布失败"
        }else {
          item.publish_status = status ==="ON_SALE"?"uppershelf":"lowershelf"
          item.publish_status_name =  status ==="ON_SALE"?"在售":"下架"
        }
        item.save()
      }
    }
  }
  async forceUpdate(pobj, status) {
    let item = await this.dao.findOne({id:pobj.actionBody.id})
      let price = item.platform_quoted_price
      item.platform_quoted_price = pobj.actionBody.price
      let obj = buildobj(item,status)
      if (obj) {
        let err = await reqbyget({
          action:"ForceUploadTrademarkOnsale",
          reqbody: obj
        })
        if (err){
          item.fail_reason = err
          item.publish_status = "fail"
          item.publish_status_name = "发布失败"
          item.platform_quoted_price = price
          item.save()
          return system.getResultError(err)
        }else {
          item.publish_status = "uppershelf"
          item.publish_status_name ="在售"
          item.save()
        }
        return system.getResultSuccess()
    }
    return system.getResultError("数据异常")
  }
  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 修改
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
      	"actionType": "tmInfoUpdate",
      	"actionBody": {
	        "id": 1756266,
          "code": "123123",
          "name": "商标名字update",
          "channel_code": "18",
          "channel_name": null,
          "excelName": "123",
          "tm_applier": "18",
          "ncl_one_code": "ali",
          "business_quoted_price": "123",
          "platform_quoted_price": "123",
          "pic_url": "123",
          "publish_status_name": "审核中",
          "publish_status": "audit",
          "tm_group": "123",
          "tm_service_item": "123",
          "tm_introduction": "123",
          "tm_start_day": "0122-12-31T15:54:17.000Z",
          "tm_end_day": "0122-12-31T15:54:17.000Z",
          "contacts": "13911391996",
          "mobile": "13911391996",
          "notes": "13911391996",
          "op_notes": "13911391996",
          "trademark_type_name": "普通商标",
          "trademark_type": "ordinary",
          "tm_regist_day": "123",
          "tm_ncl_third": "123",
          "created_at": "2020-09-03T03:08:24.000Z",
          "updated_at": "2020-09-03T03:08:24.000Z",
          "deleted_at": null,
          "version": 0
        }
      }
   * @apiSuccessExample {json} 成功示例:
   * {"status":1,"message":"success","data":{},"requestId":"eee13d10-eddf-11ea-8742-4b968455d94c"}
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
  async tmInfoUpdate(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-106, "actionBody is empty");
    }
    var res = await this.dao.update(actionBody)
    return system.getResultSuccess(res);
  }

  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 批量设置类型
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
        "actionType": "tmTrademarkTypeUpdate",
        "actionBody": [
          {
            "id": 209101,
            "trademark_type":"hot"
          },
          {
            "id": 209102,
            "trademark_type":"hot"
          }
        ]
      }
   * @apiSuccessExample {json} 成功示例:
   * {"status":1,"message":"success","data":[[1],[1]],"requestId":"16794a60-f8b8-11ea-b763-65103acda465"}
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
  async tmTrademarkTypeUpdate(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-106, "actionBody is empty");
    }
    var res = [];
    for(var i = 0;i < actionBody.length;i++) {
      var updateRes = await this.dao.update(actionBody[i])
      res.push(updateRes);
    }
    return system.getResultSuccess(res);
  }
  /**
   * @api {post} /tmtransaction/action/trademarktransaction/springBoard 删除
   * @apiGroup 标源管理
   * @apiParamExample {json} 请求参数
   * {
      	"actionType": "tmInfoDelete",
      	"actionBody": {
      		"id": "175624"
      	}
      }
   * @apiSuccessExample {json} 成功示例:
   * {"status":1,"message":"success","data":{},"requestId":"3ce70210-ee53-11ea-b8db-25de5bfcf939"}
   * @apiErrorExample {json} 失败示例:
   * {"error": ""}
   */
  async tmInfoDelete(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-106, "actionBody is empty");
    }
    var res = this.dao.delete(actionBody)
    return system.getResultSuccess(res);
  }


  async addbaseinfo(objlist) {
    var self = this;
    if (!objlist || objlist.length < 1) {
      return system.getResultFail(-106, "参数错误");
    }
    // if (objlist[0].pic_url) {
    //   // await this.addEsData(objlist);
    // } else {
    var codeList = []
    for (let i = 0; i < objlist.length; i++) {
      if(objlist[i].code){
        codeList.push(objlist[i].code);
      }
    }
    // }
    var params = {
      "query": {
        "terms": {
          "tm_regist_num": codeList
        }
      },
      "from": 0,
      "size": 500,
      "_source": [
        "pic_url",
        "tm_name",
        "tm_name_en",
        "tm_regist_num",
        "ncl_one_codes",
        "applicant_cn",
        "original_regist_notice_day",
        "tm_end_day",
        "ncl_two_codes",
        "cn_count",
        "en_name_count",
        "regist_notice_day"
      ]
    };
    var esData = await this.execPostByTimeOut(null, params, "http://er.es.gongsibao.com:7200/bigdata_middle_gsb_tm_info/_search", null);
    if (esData.status != 1) {
      return system.getResultFail(-1001, "es查询失败")
    }
    var tmlist = esData.data.hits.hits;
    for (let i = 0; i < tmlist.length; i++) {
      var tmDetail = tmlist[i]["_source"];
      var tmIndex = objlist.findIndex(f => f.code == tmDetail.tm_regist_num);

      objlist[tmIndex]["pic_url"] = tmDetail.pic_url || "";
      objlist[tmIndex]["ncl_one_code"] = tmDetail.ncl_one_codes || "";
      objlist[tmIndex]["name"] = tmDetail.tm_name || "";
      objlist[tmIndex]["tm_applier"] = tmDetail.applicant_cn || "";
      objlist[tmIndex]["tm_group"] = JSON.stringify(tmDetail.ncl_two_codes) || "";
      objlist[tmIndex]["tm_applier"] = tmDetail.applicant_cn || "";
      // 2020 0909 lin 新增 execlName 三元
      objlist[tmIndex]["excelName"] = objlist[tmIndex]["excelName"] ? objlist[tmIndex]["excelName"] : tmDetail.tm_name;
      objlist[tmIndex]["publish_status"] = objlist[tmIndex]["publish_status"] ? objlist[tmIndex]["publish_status"] : "audit"
      if (tmDetail.original_regist_notice_day) {
        objlist[tmIndex]["tm_regist_day"] = new Date(parseInt(tmDetail.original_regist_notice_day) * 1000).toISOString().split("T")[0] || "";
      }
      if (tmDetail.tm_end_day) {
        objlist[tmIndex]["tm_end_day"] = new Date(parseInt(tmDetail.tm_end_day) * 1000).toISOString().split("T")[0] || "";
      }
      if (tmDetail.regist_notice_day) {
        objlist[tmIndex]["tm_start_day"] = new Date(parseInt(tmDetail.regist_notice_day) * 1000).toISOString().split("T")[0] || "";
      }
      var nclthird = await self.getNclthird(tmDetail.tm_regist_num)
      objlist[tmIndex]["tm_ncl_third"] = JSON.stringify(nclthird) || "";
    }
    console.log(objlist)
    return objlist;
  }

  async getNclthird(tm_regist_num) {
    //商标小项查询
    var params = {
      "query": {
        "term": {
          "reg_num": tm_regist_num
        }
      },
      "from": 0,
      "size": 500,
      "_source": [
        "ncl_last"
      ]
    };
    var nclthird = [];
    var esData = await this.execPostByTimeOut(null, params, "http://er.es.gongsibao.com:7200/bigdata_bdc_ncl_info/_search", null);
    if (esData.status != 1) {
      return system.getResultFail(-1001, "es查询失败")
    }
    var nclthirdlist = esData.data.hits.hits;
    // console.log(nclthirdlist);
    for (let l = 0; l < nclthirdlist.length; l++) {
      if (nclthirdlist[l]["_source"].ncl_last) {
        if (nclthirdlist[l]["_source"].ncl_last.indexOf(":") != -1) {
          var sptirdncl = nclthirdlist[l]["_source"].ncl_last.split(":")[1];
          if (nclthird.indexOf(sptirdncl) < 0) {
            nclthird.push(sptirdncl);
          }
        }
        else {
          if (nclthird.indexOf(nclthirdlist[l]["_source"].ncl_last) < 0) {
            nclthird.push(nclthirdlist[l]["_source"].ncl_last);
          }
        }
      }

    }
    return nclthird;
  }


  async createjsonfile() {
    var nowTime = new Date();
    nowTime.setMinutes(nowTime.getMinutes() - 30);
    var lastTimeStr = nowTime.toISOString().split("T")[0] + " " + nowTime.toISOString().split("T")[1];
    var sql = "select * from tm_transaction where updated_at>='" + lastTimeStr + "' and publish_status in ('uppershelf','lowershelf')";
    var tminfos = await this.dao.customQuery(sql);
    var sources = [];
    if (tminfos) {
      if (tminfos.length < 1) {
        return null;
      }
      for (var i = 0; i < tminfos.length; i++) {
        var tmg = tminfos[i].tm_group;
        var status = 1;
        if (tminfos[i].deleted_at || "lowershelf" == tminfos[i].publish_status) {
          status = 0;
        }
        var strlist = null;
        if (tmg) {
          strlist = tmg.replace(/"/g, "").replace(/\[/g, "").replace(/\]/g, "").split(",");
          for (var n = 0; n < strlist.length; n++) {
            if (!strlist[n]) {
              strlist.shift();
            }
          }
        }
        var des = "";
        if (tminfos[i].tm_ncl_third) {
          des = tminfos[i].tm_ncl_third.replace(/\[/g, "").replace(/\]/g, "").replace(/\'/g, "");
        }
        var source = {
          beginTime: 1574388139000,
          classificationCode: tminfos[i].ncl_one_code,
          description: des,
          endTime: 1668089537981,
          label: "商标标签",
          originalPrice: parseInt(tminfos[i].platform_quoted_price),
          ownerEnName: "",
          ownerName: tminfos[i].tm_applier,
          partnerCode: "gong_si_bao",
          regAnnDate: tminfos[i].tm_regist_day * 1000,
          secondaryClassification: strlist,
          status: status,
          thirdClassification: tminfos[i].tm_ncl_third,
          tmIcon: tminfos[i].pic_url,
          tmName: tminfos[i].name,
          tmNumber: tminfos[i].code,
          Type: tminfos[i].type,
          Reason: tminfos[i].reason
        }
        sources.push(source);
      }
      var newdate = new Date();
      var strdate = ""
      if (newdate.getHours() > 12) {
        strdate = newdate.toISOString().split("T")[0].replace(/\-/g, "") + "_2.json";
      } else {
        strdate = newdate.toISOString().split("T")[0].replace(/\-/g, "") + "_1.json";
      }
      var jsonstr = JSON.stringify(sources, null, "\t");
      var a = await new Promise(function (resv, rej) {
        fs.writeFile("/tmp/" + strdate, jsonstr, function (err) {
          if (err) {
            console.error(err);
          }
          console.log('--------------------修改成功11111111111111');
          return resv({ status: 0, msg: "成功" })
        })
      }
      )
      var rtn = await this.ossClient.upfile(strdate, "/tmp/" + strdate);
      return {
        status: 1,
        msg: "",
        data: rtn
      };
    }

  }

  async tmStatusCheck(pobj, actionBody) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-103, "actionBody is empty");
    }
    var tmInfo = await this.dao.model.findOne({
      where: { 
        code: actionBody.code,
      },
      attributes: [
        "id",
        "publish_status"
      ],
      raw: true
    });
    return system.getResultSuccess(tmInfo);
  }


}
module.exports = TrademarktransactionService;

// var a = new TrademarktransactionService();
// a.addbaseinfo([{ "code": "22426244" }, { "code": "31566397" }, { "code": "37222371" }]);
// a.createjsonfile();
