var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const moment = require("moment");

class BusistatCtl extends CtlBase {
    constructor() {
        super(CtlBase.getServiceName(BusistatCtl));
        this.departmentSve = system.getObject("service.departmentSve");
        this.excelClient = system.getObject("util.excelClient");
    }

    async suggest(query,qobj,req){
        var name = this.trim(qobj.name);
        if (!name) {
            return system.getResult2([])
        }
        var list = await this.departmentSve.suggestByName(name);
        return system.getResult2(list);
    }

    async signList(queryobj, qobj, req) {
        var params = qobj.search;
        try {
            var page = await this.service.signPage(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async signExport(pobj, req, res) {
        var params = JSON.parse(pobj.search);
        try {
            params.currentPage = 1;
            params.pageSize = 60000;
            var page = await this.service.signPage(params);
            var csvobj = {
                fileName: "发薪统计-" + moment().format("YYYYMMDD") + ".csv",
                rows: page.rows,
                opts: {
                    fields: ['id', 'busi_id', 'busi_name', 'user_name','user_department_name','times','amt','actual_amt','deduct_amt','income_tax','service_tax','added_value_tax'],
                    unwind: ['busistat'],
                    excelStrings: true,
                    unwindBlank: true
                },
                headers: {
                    "id": "编号",
                    'busi_id': "商户id",
                    'busi_name': "企业名称",
                    'user_name': "业务员姓名",
                    'user_department_name':"业务员部门",
                    'times':"发薪次数",
                    'amt':"申请发薪金额",
                    'actual_amt':"实发金额",
                    'deduct_amt':"扣除金额",
                    'income_tax':"个税",
                    'service_tax':"服务费",
                    'added_value_tax':"增值税"
                },
            };
            await this.excelClient.exportCsv(req, res, csvobj);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }



}

module.exports = BusistatCtl;
