const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("eintention", {
    name: DataTypes.STRING,
    credit_code: DataTypes.STRING(255), // 统一社会信用代码
    contractName: DataTypes.STRING(20), // 联系人
    contractMobile: DataTypes.STRING(20), // 联系人电话
    contractPost: DataTypes.STRING(20), // 联系人电话

    owner_id:DataTypes.INTEGER, // 所属人id
    owner_name:DataTypes.STRING(100), // 所属人id
    update_id:DataTypes.INTEGER, // 所属人id
    update_name:DataTypes.STRING(100), // 所属人id
    ecompanyLevelName: {
      // 客户等级名称
      type: DataTypes.STRING(20),
      defaultValue: "普通",
    },
    ecompanyLevel: {
      // 客户等级  0普通 1小微 2重要
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.ecompanyLevel),
      set: function (val) {
        this.setDataValue("ecompanyLevel", val);
        this.setDataValue("ecompanyLevelName", uiconfig.config.pdict.ecompanyLevel[val]);
      },
      defaultValue: "0",
    },
    ecompanySourceTypeName: {
      // 客户来源名称
      type: DataTypes.STRING(20),
      defaultValue: "直接开发",
    },
    ecompanySourceType: {
      // 客户来源 0:直接开发,10:转介绍,20:扫码推广,90:其他来源
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.ecompanySourceType),
      set: function (val) {
        this.setDataValue("ecompanySourceType", val);
        this.setDataValue("ecompanySourceTypeName", uiconfig.config.pdict.ecompanySourceType[val]);
      },
      defaultValue: "0",
    },
    cityCode: DataTypes.STRING,
    cityName: DataTypes.STRING(20),
    pcode: DataTypes.STRING(30),
    ccode: DataTypes.STRING(30),
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_eintention',
    validate: {
    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}