const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("epartnerupgradeaudit", {
    nickName: DataTypes.STRING(20),
    mobile: DataTypes.STRING(20),
    epartner_id: DataTypes.INTEGER, // 合伙人id
    sourceTypeName:{
      // 当前类型名称
      type:DataTypes.STRING(20),
      defaultValue:"初级",
    },
    sourceType: {
      // 当前类型 0初级 1一级 2二级
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerType),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.partnerType[val]);
      },
      defaultValue: "0",
    },
    targetTypeName:{
      // 升级类型名称
      type:DataTypes.STRING(20),
      defaultValue:"初级",
    },
    targetType: {
      // 升级类型 0初级 1一级 2二级
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.partnerType),
      set: function (val) {
        this.setDataValue("targetType", val);
        this.setDataValue("targetTypeName", uiconfig.config.pdict.partnerType[val]);
      },
      defaultValue: "0",
    },

    auditStatusName:{
      // 审核状态名称
      type:DataTypes.STRING(20),
      defaultValue:"待审核",
    },
    auditStatus: {
      // 审核状态 "0":"待审核","1":"审核通过","2":"审核驳回"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.auditStatus),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.auditStatus[val]);
      },
      defaultValue: "0",
    },
    audit_id: DataTypes.INTEGER,
    audit_at: DataTypes.DATE,
    audit_remark:DataTypes.STRING(255),
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_epartner_upgrade_audit',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}