const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("esettlecommission", {
    month: DataTypes.INTEGER,
    esettle_id: DataTypes.INTEGER,
    ecompany_id: DataTypes.INTEGER,
    ecompanyName: DataTypes.STRING(100),
    amt: DataTypes.BIGINT(20),
    out_trade_no: DataTypes.STRING(32),
    service_rate: DataTypes.DOUBLE(11, 2),
    service_tax: DataTypes.BIGINT(20),

    commission: DataTypes.BIGINT(20),

    epartner_id: DataTypes.INTEGER,
    user_id: DataTypes.INTEGER,
    epartnerSourceName: DataTypes.STRING(20),
    pay_complete_time: DataTypes.DATE,

    commissionTypeName:{
      // 合伙人类型名称
      type:DataTypes.STRING(20),
      defaultValue:"首次发薪提成",
    },
    commissionType: {
      // 提成类型 0首次发薪提成 1每次发薪提成 2佣金提成
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.commissionType),
      set: function (val) {
        this.setDataValue("commissionType", val);
        this.setDataValue("commissionTypeName", uiconfig.config.pdict.commissionType[val]);
      },
      defaultValue: "0",
    },
    commissionSourceName:{
      // 提成来源名称
      type:DataTypes.STRING(20),
      defaultValue:"首次发薪提成",
    },
    commissionSource: {
      // 提成来源 0我的客户 1合伙人
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.commissionSource),
      set: function (val) {
        this.setDataValue("commissionSource", val);
        this.setDataValue("commissionSourceName", uiconfig.config.pdict.commissionSource[val]);
      },
      defaultValue: "0",
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_esettle_commission',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}