const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("proxyapplicant", {
    userName: DataTypes.STRING(20),
    mobile: DataTypes.STRING(20),
    city: DataTypes.STRING(20),
    intro: DataTypes.STRING,
    owner_id: DataTypes.INTEGER,
    auditStatusName:{
      // 审核状态名称
      type:DataTypes.STRING(20),
      defaultValue:"待审核",
    },
    auditStatus: {
      // 审核状态 "0":"待审核","1":"审核通过","2":"审核驳回"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.proxyAuditStatus),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.proxyAuditStatus[val]);
      },
      defaultValue: "0",
    },
    audit_id: DataTypes.INTEGER,
    user_id: DataTypes.INTEGER,
    advNames: DataTypes.STRING,
    isEnabled: {
      type: DataTypes.BOOLEAN,
      defaultValue: true
    },
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'b_proxy_applicant',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}