const system = require("../../system");
const ServiceBase = require("../sve.base");

class BusistatService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(BusistatService));
    }
    async syncDayData(statDay, list) {
        if (!list || list.length == 0) {
            return;
        }
        await this.dao.delByDay(statDay);
        await this.dao.bulkCreate(list);
    }

    async updateDepartmentName(params) {
        return await this.dao.updateDepartmentName(params);
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.busi_name) {
            where.busi_name = {
                [this.db.Op.like]: "%" + params.busi_name + "%"
            };
        }

        if (params.user_department_name) {
            where.user_department_name = params.user_department_name;
        }

        var orderby = [
            ["id", 'desc']
        ];

        var page = await this.getPageList(currentPage, pageSize, where, orderby);
        if (page && page.rows) {
            for(var row of page.rows) {
                this.handleDate(row, ["created_at" , "updated_at"]);
            }
            // await this.setCompany(page.rows);
            // await this.setMain(page.rows);
        }
        return page;
    }
}

module.exports = BusistatService;
