var system = require("../../system");
var settings = require("../../../config/settings");
const microService = require("../svems.base");

// 渠道服务
class ChannelService extends microService {
  constructor() {
    super();
    this.restClient = system.getObject("util.restClient");
    this.ossClient = system.getObject("util.ossClient");
  }

  // 来源api
  async originDics(params) {
    return await this.callms("channel", "originDics", params);
  }
  async originInfo(params) {
    return await this.callms("channel", "originInfo", params);
  }
  async originMerchants(params) {
    return await this.callms("channel", "originMerchants", params);
  }

  // 渠道api
  async channelSuggest(params) {
    return await this.callms("channel", "channelSuggest", params);
  }
  async channelDicts(params) {
    return await this.callms("channel", "channelDicts", params);
  }
  async channelInfo(params) {
    return await this.callms("channel", "channelInfo", params);
  }
  async channelSave(params) {
    return await this.callms("channel", "channelSave", params);
  }
  async channelPage(params) {
    return await this.callms("channel", "channelPage", params);
  }

  async bindPlatform(params){
    return await this.callms("channel" , "bindPlatform", params);
  }

  async pushbindingchannel(params){
    return await this.callms("channel" , "pushbindingchannel", params);
  }

  // 商户api
  async merchantInfo(params) {
    return await this.callms("channel", "merchantInfo", params);
  }
  async merchantSave(params) {
    return await this.callms("channel", "merchantSave", params);
  }
  async merchantSaves(params) {//峰擎推送添加
    return await this.callms("channel", "merchantSaves", params);
  }
  async merchantPage(params) {
    return await this.callms("channel", "merchantPage", params);
  }

  async getPushMerchantIds(params){
    return await this.callms("channel" , "getPushMerchantIds", params);
  }
}
module.exports = ChannelService;
