const system=require("../../system");
const ServiceBase=require("../sve.base");
class EnttemplateService extends ServiceBase{
    constructor(){
        super(ServiceBase.getDaoName(EnttemplateService));

        this.ecompanyDao = system.getObject("db.entcompanyDao");
        this.dkaggreementDao = system.getObject("db.dkaggreementDao");
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.name) {
            where.name = {
                [this.db.Op.like]: "%" + params.name + "%"
            };
        }
        if (params.ecompanyIds) {
            where.entcompany_id = {
                [this.db.Op.in]: params.ecompanyIds
            };
        }
        if (params.entcompany_id) {
            where.entcompany_id = params.entcompany_id;
        }
        var orderby = [
            ["id", 'desc']
        ];

        var attributes = ["id", "entcompany_id", "aggreement_id", "name", "codeurl", "remark", "created_at", "updated_at"];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for(var row of page.rows) {
                this.handleDate(row, ["created_at" , "updated_at"]);
            }
            await this.setCompany(page.rows);
            await this.setAggreement(page.rows);
        }
        return page;
    }

    async getListByName(name){
        return await this.dao.getListByName(name);
    }

    async setCompany(list) {
        if (!list || list.length == 0) {
            return;
        }

        var companyIds = [];
        for (var item of list) {
            companyIds.push(item.entcompany_id || 0);
        }
        var companyMap = await this.ecompanyDao.findMapByIds(companyIds, " id, name ");
        for (var item of list) {
                item.entcompany = companyMap["id_" + (item.entcompany_id || 0)];
        }
    }
    async setAggreement(list) {
        if (!list || list.length == 0) {
            return;
        }
        var aggreementIds = [];
        for (var item of list) {
            aggreementIds.push(item.aggreement_id || 0);
        }

        var aggreementMap = await this.dkaggreementDao.findMapByIds(aggreementIds);
        for (var item of list) {
            item.entaggreement = aggreementMap["id_" + (item.aggreement_id || 0)];
        }
    }

    async getInfo(id) {
        var attrs = ["id", "name", "ecompanyMainId", "mainId", "nameA", "templateid", "filekey", "filepath", "qrcodeurl",
            "placeholderkey", "isEnabled", "created_at", "updated_at", "ecompany_id"];
        return await this.dao.model.findOne({
            where: { id: id }, attrs, raw: true
        });
    }

    async findReadyContracts(obj){
        obj.isEnabled=true;
        let sql = "SELECT t1.*, t2.id AS companyid, t2.`name` AS companyname " +
            "FROM `c_etemplate` t1 " +
            "INNER JOIN c_ecompany t2 ON t1.`ecompany_id` = t2.id " +
            "WHERE t1.isEnabled = 1 AND t1.ecompany_id = :ecompany_id " +
            "AND t1.id NOT IN  (SELECT etemplate_id FROM `c_econtract` WHERE usereaccount_id = :usereaccount_id  AND eflowstatus = '2') " +
            "AND t2.`deleted_at` IS NULL AND t1.`deleted_at` IS NULL ";

        let params = {ecompany_id:obj.ecompany_id, usereaccount_id : obj.eaccount_id};
        var list = await this.dao.customQuery(sql, params);
        if(!list || list.length == 0) {
            return [];
        }
        list.forEach(item => {
            var ecompany = {};
            ecompany.id = item.companyid;
            ecompany.name = item.companyname;
            item.ecompany = ecompany;
        });
        return list;
    }
}
module.exports=EnttemplateService;
