const system = require("../system");
const settings = require("../../config/settings");
const moment = require("moment");
const axios = require("axios");

class ServiceBase {
  constructor(daoName) {
    this.md5 = require("MD5");
    this.micro = system.microsetting();
  }

  /**
   * 请求微服务
   * @param {*} sveName 服务名称
   * @param {*} apiName api名称
   * @param {*} params 参数 
   */
  async callms(sveName, apiName, params) {
    var reqUrl = this.micro[sveName];
    console.log(reqUrl, "-----------------------------");

    if (!reqUrl) {
      return system.getResult(null, "未找到【" + sveName + "】服务，请检查settings文件是否存在");
    }
    if (!apiName) {
      return system.getResult(null, "apiName不能为空");
    }
    try {
      var params = {
        "action_process": "bpo-admin",
        "action_type": apiName,
        "action_body": params || {},
      }
      if (settings.env == 'dev') {
        let rs = await axios({
          method: 'post',
          url: reqUrl,
          data: params
        });

        console.log(rs);
        return rs.data;
      }
      var rs = await this.restClient.execPost(params, reqUrl);
      if (rs && rs.stdout) {
        return JSON.parse(rs.stdout);
      }
      return system.getResult(null, rs);
    } catch (error) {
      console.log(error);
      this.logCtl.error({
        optitle: "微服务请求失败",
        op: "sveName = " + sveName + "; apiName = " + apiName,
        content: "params = " + JSON.stringify(params),
        clientIp: ""
      });
      return system.getResult(null, error.message);
    }
  }

  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
  encryptPasswd(passwd) {
    if (!passwd) {
      throw new Error("请输入密码");
    }
    var md5 = this.md5(passwd + "_" + settings.salt);
    return md5.toString().toLowerCase();
  }
  handleDate(row, fields, pattern, addHours) {
    pattern = pattern || "YYYY-MM-DD HH:mm";
    if (!row) {
      return;
    }
    for (var field of fields) {
      if (row[field]) {
        if (addHours) {
          row[field] = moment(row[field]).add(addHours, "hours").format(pattern);
        } else {
          row[field] = moment(row[field]).format(pattern);
        }
      }
    }
  }

  addWhereTime(where, field, begin, end) {
    if (!begin && !end) {
      return;
    }

    if (begin && end) {
      where[field] = {
        [this.db.Op.between]: [begin, end]
      };
    } else if (begin && !end) {
      where[field] = {
        [this.db.Op.gte]: begin
      };
    } else if (!begin && end) {
      where[field] = {
        [this.db.Op.lte]: end
      };
    }
  }

  trim(o) {
    if (!o) {
      return "";
    }
    return o.toString().trim();
  }
}
module.exports = ServiceBase;
