{
    template: '${tmpl}',
    data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

        return {
            showDetail: false,
            showEdit: false,
            selname: "",
            
            submitLoading:false,
            isFirstEdit: true,
            eduTypeList: [],
            search: {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                dkcompany_id: '',
                accountName: '',
                templateName: '',
                accountMobile: '',
                accountIdno: '',
                signBegin: '',
                signEnd: '',
            },
            rules: {
                dkcompanyName : [
                    { required: true, message: '请输入公司名称', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                userName: [
                    { required: true, message: '请输入姓名', trigger: 'blur' },
                ],
                mobile: [
                    { required: true, message: '请输入手机号', trigger: 'blur' },
                    { validator: validMethod, trigger: 'blur' }
                ],
                personsSign: [
                    { required: true, message: '请输入身份证', trigger: 'blur' },
                ],
                bankno: [
                    { required: true, message: '请输入银行卡', trigger: 'blur' },
                ],
                fileurl: [
                    { required: true, message: '请上传签约协议', trigger: 'blur' },
                ],
                a : [],
            },

            nameLoading: false,
            nameList: [],
            nameMap:[],

            nameLoading2: false,
            nameList2: [],
            nameMap2:[],
            uploadResult: null,

            aggreement: {},
        }
    },
    mounted: function () {
        this.resetSearch();
    },
    created: function () {},
    methods: {

        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total: 0,
                dkcompany_id: '',
                accountName: '',
                templateName: '',
                accountMobile: '',
                accountIdno: '',
                signBegin: '',
                signEnd: '',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.selname = "";
            this.getList();
        },
        tableHeaderColor({row, column, rowIndex, columnIndex}) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.getList();
        },
        getList() {
            var self = this;
            this.$root.postReq("/web/dkcontractCtl/myList", {
                search: self.getParams()
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {}
            });
        },
        getParams() {
            var params = {};
            for (var f in this.search) {
                if (f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        exportList() {
            window.open("/web/dkcontractCtl/myExport" + this.getExportParams());
        },
        getExportParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return "?search=" + encodeURIComponent(JSON.stringify(params));
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'name') {
                if(!self.intention.name) {
                    return callback(new Error("请输入客户名称"));
                }

                self.$root.postReq("/web/eintentionCtl/validName", {
                    name: self.intention.name
                }).then(function (d) {
                    if (d.status == 0) {
                        return callback();
                    } else {
                        return callback(new Error(d.msg));
                    }
                });
            } else {
                return callback();
            }

            if(rule.field == "dkcompanyName") {
                if(!self.aggreement.dkcompany_id) {
                    return callback(new Error("请重新选择公司名称"));
                }
            }
            if(rule.field == "mobile") {
                if(!/^(1)\d{10}$/.text(self.aggreement.mobile)) {
                    return callback(new Error("请输入公司名称"));
                }
            }
        },
        changeStatus() {
            this.curStatus = this.search.applyStatus;
            this.search.currentPage = 1;
            this.search.pageSize = 20;
            this.search.total = 0;
            this.getList();
        },
        openEdit() {
            var self = this;
            self.nameList = [];
            self.aggreement = {};
            self.showEdit = true;
            if(self.isFirstEdit) {
                self.isFirstEdit = false;
            } else {
                self.$refs.aggreement.resetFields();
                self.clearUpload();
            }
        },
        nameChange(val) {
            console.log(val, "------------------------- ");
            var self = this;
            var item = self.nameMap[val];
            self.search.dkcompany_id = (item || {}).id || "";
        },
        nameChange2(val) {
            var self = this;
            var item = self.nameMap2[val];
            self.aggreement.dkcompany_id = (item || {}).id || "";

            console.log(val,self.aggreement.dkcompany_id, "------------------------- ");
        },
        delitem(item) {
            var self = this;
            self.$confirm("确认删除【" + item.eaccount.userName + "】的签约记录？", {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'success'
            }).then(() => {
                self.$root.postReq("/web/dkcontractCtl/delById", {id : item.id}).then(function (d) {
                    if (d.status == 0) {
                        self.getList();
                        self.$message.success("删除成功");
                    } else {
                        self.$alert(d.msg || '保存失败', '提示', {
                            confirmButtonText: '确定',
                            callback: action => {}
                        });
                    }
                    self.submitLoading = false;
                });
            }).catch(() => {
            });
        },
        save() {
            var self = this;

            self.submitLoading = true;
            self.$refs.aggreement.validate((valid) => {
                if (valid) {
                    setTimeout(() => {
                        self.submitLoading = false;
                    }, 5000);
                    self.$root.postReq("/web/dkcontractCtl/saveOffline", self.aggreement).then(function (d) {
                        if (d.status == 0) {
                            self.getList();

                            self.$confirm("保存成功，继续录入下一条？", {
                                confirmButtonText: '确定',
                                cancelButtonText: '取消',
                                type: 'success'
                            }).then(() => {
                                self.aggreement = {};
                                self.clearUpload();               
                            }).catch(() => {
                                self.showEdit = false;
                            });
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.submitLoading = false;
                    });
                } else {
                    self.submitLoading = false;
                    return false;
                }
            });
        },
        
        getCompanyNames(query) {
            var self = this;
            self.nameLoading = true;
            self.$root.postReq("/web/dkcompanyCtl/suggest", {
                name: query,
                ismy: false,
            }).then(function (d) {
                self.nameLoading = false;
                self.nameList = d.data || [];
                self.nameMap = [];
                for(var item of self.nameList) {
                    self.nameMap[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading = false; 
            }, 15000);
        },
        getCompanyNames2(query) {
            var self = this;
            self.nameLoading2 = true;
            self.$root.postReq("/web/dkcompanyCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading2 = false;
                self.nameList2 = d.data || [];
                self.nameMap2 = [];
                for(var item of self.nameList2) {
                    self.nameMap2[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading2 = false; 
            }, 15000);
        },

        clearUpload() {
            var self = this;
            self.uploadResult = null;
            self.aggreement.fileurl = "";
            if(self.$refs.upload3 && self.$refs.upload3.$refs && self.$refs.upload3.$refs.upload) {
                self.$refs.upload3.$refs.upload.clearFiles();
            }
        },
        uploadsuccess(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.aggreement.fileurl = v[0].url;
        },

        downloadContractUrl(id) {
            var self = this;
            self.$root.postReq("/web/dkcontractCtl/downloadContractUrl", {
                id: id
            }).then(function (d) {
                if (d.status == 0 && d.data) {
                    window.open(d.data);
                } else {
                    self.$message.warning(d.msg || "上传失败");
                }
            });
        },
    },
    vname: "gsb-dkcontractall"
}