{
    template: '${tmpl}',
        data: function () {
    var validMethod = (rule, value, callback) => {
        return this.validfileds(rule, value, callback);
    };

    return {
        entcompany: {},
        editTitle: "新增",
        showEdit: false,
        saveLoading: false,
        ownerList:[],
        ownerMap:[],
        ownerLoading:false,
        owner_id: "",
        search: {
            list: [],
            currentPage: 1,
            pageSize: 20,
            total : 0,
            name:'',
        },
        rules: {
            name : [
                { required: true, message: '请输入企业名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            legal : [
                { required: true, message: '请输入法人姓名', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            contactName : [
                { required: true, message: '请输入联系人姓名', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            addr : [
                { required: true, message: '请输入联系地址', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            contactMobile: [
                { required: true, message: '请输入联系电话', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            sealName: [
                { required: true, message: '请输入公章名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            bankAccount: [
                { required: true, message: '请输入账户名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            bankName: [
                { required: true, message: '请输入开户行地址', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            bankNo: [
                { required: true, message: '请输入银行账号', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            owner_id: [
                { required: true, message: '请选择客户归属人员', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            a : [],
        },
    }
},
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/entcompanyCtl/mySignList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        getDKcompany(id) {
            var self = this;
            self.$root.postReq("/web/entcompanyCtl/info", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        d.data.isEnabled = d.data.isEnabled ? true : false;
                    }
                    self.entcompany = d.data;
                    self.entcompany.owner_id = self.entcompany.owner_id || "";
                    self.owner_id = (d.data.owner || {}).id || "";
                    if(d.data.owner) {
                        self.ownerList = [d.data.owner];
                        self.ownerMap["id_" + d.data.owner.id] = d.data.owner;
                    } else {
                        self.ownerList = null;
                    }
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            this.ownerLoading = false;
            this.saveLoading = false;
            this.owner_id = null;
            if(this.$refs.entcompany) {
                this.$refs.entcompany.resetFields();
            }
            if(id) {
                this.getDKcompany(id);
                this.editTitle = "修改";
            } else {
                this.ownerList = [];
                this.editTitle = "新增";
                this.entcompany = {isEnabled:true};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == 'owner_id') {
                if(!self.entcompany.owner_id) {
                    return callback(new Error("请选择归属人员"));
                } else {
                    return callback();
                }
            } else {
                return callback();
            }
        },

        ownerChange(val) {
            console.log(val, );
            this.entcompany.owner_id = val || 0;
            this.owner = this.ownerMap["id_" + val];
            console.log(this.owner);
        },
        getOwnerList(query) {
            var self = this;
            self.ownerLoading = true;
            self.$root.postReq("/web/userCtl/rolesSuggest", {
                name: query,
                roleCodes: ["zczy", "zcgl", "qdzy", "qdgl", "ptzy", "ptgl", "dkhzy", "dkhgl", "ziying", "tzgl", "tzzy"]
            }).then(function (d) {
                self.ownerLoading = false;
                self.ownerList = d.data || [];
                self.ownerMap = [];

                for (var o of self.ownerList) {
                    self.ownerMap["id_" + o.id] = o;
                }
            });
            setTimeout(() => {
                self.ownerLoading = false;
            }, 15000);
        },
        saveCompany() {
            var self = this;
            self.saveLoading = true;
            self.$refs.entcompany.validate((valid) => {
                if (valid) {
                    self.$root.postReq("/web/entcompanyCtl/signSave", self.entcompany).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
            setTimeout(() => {
                self.saveLoading = false;
            }, 5000);
        },
    },
    vname: "gsb-entcompanyadmin"
}