{
    template: '${tmpl}',
        data: function () {
        var validMethod = (rule, value, callback) => {
            return this.validfileds(rule, value, callback);
        };

    return {
        offlinecompanys: {},
        editTitle: "新增",
        showEdit: false,
        saveLoading: false,
        ownerList:[],
        ownerMap:[],
        ownerLoading:false,
        owner_id: "",
        search: {
            list: [],
            currentPage: 1,
            pageSize: 20,
            total : 0,
            name:'',
        },
        rules: {
            company_name: [
                { required: true, message: '请输入商户名称', trigger: 'blur' },
            ],
            contact_man: [
                { required: true, message: '请输入联系人', trigger: 'blur' },
            ],
            contact_mobile : [
                { required: true, message: '请输入联系电话', trigger: 'blur' },
            ],
            contact_email: [
                { required: true, message: '请输入联系邮箱', trigger: 'blur' },
            ],
            contact_addr : [
                { required: true, message: '请输入联系地址', trigger: 'blur' },
            ],
        },
    }
},
    mounted: function () {
        this.resetSearch(true);
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },

        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/offlinecompanyCtl/allList", params).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },

        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },

        openEdit(id) {
            this.ownerLoading = false;
            this.saveLoading = false;
            this.owner_id = null;
            if(this.$refs.offlinecompanys) {
                this.$refs.offlinecompanys.resetFields();
            }
            if(id) {
                this.getDKcompany(id);
                this.editTitle = "修改";
            } else {
                this.editTitle = "新增";
                this.offlinecompanys = {};
            }
            this.showEdit = true;
        },

        getDKcompany(id) {
            var self = this;
            self.$root.postReq("/web/offlinecompanyCtl/getinfo", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    self.offlinecompanys = d.data;
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },

        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },

        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },

        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },

        saveCompany() {
            var self = this;
            self.saveLoading = true;
            self.$refs.offlinecompanys.validate((valid) => {
                if (valid) {
                    self.$root.postReq("/web/offlinecompanyCtl/companylSave", self.offlinecompanys).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(d.msg);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
            setTimeout(() => {
                self.saveLoading = false;
            }, 5000);
        },


    },
    vname: "gsb-dkcompanyadmin"
}
