var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsUcommuneSve = system.getObject("service.utilsSve.utilsUcommuneSve");
    }
    /**
      * 优客工厂 
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getIndustryInfo":// 获取行业信息
                opResult = await this.utilsUcommuneSve.getUserInfo(pobj, pobj.actionBody);
                break;
            case "placeOrder":// 提交订单
                opResult = await this.utilsUcommuneSve.getOrderList(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;