var WEBBase = require("../../web.base");
var system = require("../../../system");
class ChannelAccessAuthAPI extends WEBBase {
    constructor() {
        super();
        this.utilsChannelAuthSve = system.getObject("service.utilsSve.utilsChannelAuthSve");
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
        this.utilsTmAliyunSve = system.getObject("service.utilsSve.utilsTmAliyunSve");//测试用
    }
    /**
          * 接口跳转-POST请求
          * action_process  执行的流程
          * action_type     执行的类型
          * action_body     执行的参数
          */
    async springBoard(pobj, qobj, req) {
        // if (!pobj.actionProcess) {
        //     return system.getResult(null, "actionProcess参数不能为空");
        // }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = system.getResult(null, "req Failure");
        pobj.actionBody.userpin = pobj.actionBody.userpin || this.getUUID();
        switch (action_type) {
            // sy
            case "test"://测试
                console.log(pobj, "...test....pobj.actionBody....");
                opResult = system.getResultSuccess(null, "测试成功");
                opResult.status = 1;
                break;
            case "getUserPinByAliCode"://渠道通过账户进行登录，有则返回用户信息，没有则创建用户
                var aliUserResult = await this.utilsChannelAuthSve.getH5AliDingUserByCode(pobj, pobj.actionBody);
                if (aliUserResult.status != 0) {
                    return aliUserResult;
                }
                pobj.actionType = "getLoginByUserName";
                pobj.actionBody.channelUserId = aliUserResult.data.channelUserId;
                pobj.actionBody.isAdmin = aliUserResult.data.isAdmin;
                pobj.actionBody.isSuper = aliUserResult.data.isSuper;
                var tmpOpResult = await this.utilsAuthSve.getLoginByUserName(pobj, pobj.actionBody);
                if (tmpOpResult.status != 0 && tmpOpResult.status != 2060) {
                    return tmpOpResult;
                }
                opResult = system.getResultSuccess({ userpin: pobj.actionBody.userpin })
                if (tmpOpResult.status == 2060) {
                    opResult.msg = tmpOpResult.msg;
                    opResult.data.userpin = tmpOpResult.data.userpin;
                }
                break;
            case "getDingJsApiAuthInfo"://获取钉钉鉴权信息
                opResult = await this.utilsChannelAuthSve.getDingJsApiAuthInfo(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = ChannelAccessAuthAPI;