var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class NameAPI extends WEBBase{
    constructor() {
        super();
        this.redisClient = system.getObject("util.redisClient");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.centerOrderUrl = settings.centerOrderUrl();
        this.centerCacheUrl = settings.centerCacheUrl();
    }
    /**
      * 接口跳转-POST请求
      * action_type   执行的类型
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        pobj.requestId = req.requestId;
        switch (action_type) {
            case "getCache"://行业类别
                opResult = await this.getCache();
                break;
            case "getPreference"://偏好
                opResult=await this.getPreference();
                break;
            case "createName"://起名
                opResult =await this.addOrderDelivery(pobj,pobj.actionBody);
                break;
            case "getNameDetail"://详情
                opResult = await this.getNameDetail(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    /**
     * 获取行业类别数据 後期可提出為一個service文件
     * @returns {Promise<{}>}
     */
    async getCache(){
        let cacheResult = {};
        cacheResult.cache = cacheJson
        return system.getResult(cacheResult);
    }

    /**
     * 获取偏好信息 後期可提出為一個service文件
     * @returns {Promise<{}>}
     */
    async getPreference(){
        let preResult = {};
        const key = 'qmbpreference';
        let result = await this.redisClient.get(key)
        if(result){
            preResult.preference = JSON.parse(result);
            return system.getResult(preResult);
        }else{
            const data = await this.restPostUrl({},this.centerCacheUrl+"preference_select");
            if(data.code == 200){
                await this.redisClient.set(key,JSON.stringify(data.data),2*3600)
                preResult.preference = data.data
                return system.getResult(preResult);
            }
        }
    }

    /**
     * 获取起名数据并添加到c_order_delivery 后期可提取为一個service文件
     * @param pobj
     * @param actionBody
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: *, status: number}|{msg: *, data: *, status: *}|{msg: *, data: (*|null), status: number}>}
     */
    async addOrderDelivery(pobj,actionBody){
        if (!actionBody.orderId) {
            return system.getResult(null, "orderId参数不能为空");
        }
        if (!actionBody.province) {
            return system.getResult(null, "province参数不能为空");
        }
        if (!actionBody.city) {
            return system.getResult(null, "city:参数不能为空");
        }
        if (!actionBody.county) {
            return system.getResult(null, "county参数不能为空");
        }
        if (!actionBody.pcate) {
            return system.getResult(null, "pcate参数不能为空");
        }
        if (!actionBody.cate) {
            return system.getResult(null, "cate参数不能为空");
        }
        if (!actionBody.preference) {
            return system.getResult(null, "preference参数不能为空");
        }
        await this.redisClient.set("ch"+JSON.stringify(actionBody.orderId),JSON.stringify(actionBody));
        return system.getResultSuccess();
    }


    //获取取名结果，并保存到数据库
    async getNameDetail(pobj){
        pobj.actionType = 'getOrderDeliveryInfo';
        const  opResult = await this.utilsOrderSve.getOrderDeliveryInfo(pobj, pobj.actionBody);
        if(opResult.status != 0){
            return system.getResult(null,opResult.msg);
        }
        if(opResult.data.hasOwnProperty('result_name')){
            return system.getResult(opResult.data,'操作成功');
        }
        let actionBody =await this.redisClient.get('ch'+ JSON.stringify(pobj.actionBody.orderNo));
        if(!actionBody){
            return system.getResult(null)
        }
        let nameResult = await this.restPostUrl(JSON.parse(actionBody),this.centerCacheUrl+"treasure_name");
        if(nameResult.code == 200){
            pobj.actionType = 'addOrderDelivery';
            pobj.actionBody = nameResult.data;
            //取名结果存储
            let result = await this.restPostUrl(pobj,this.centerOrderUrl + "action/nameOrder/springBoard");
            return system.getResult(nameResult.data,"操作成功");
        }
        return system.getResult(null,'try again');
    }
}

const cacheJson = {
    "科技类": ["网络科技", "电子商务", "信息技术", "游戏", "电子", "软件", "新材料", "生物科技", "教育科技", "环保科技", "信息科技"],
    "许可类": ["投资管理", "金融", "资产", "商业保理", "融资租赁", "医疗器械", "人力资源", "食品", "劳务派遣"],
    "服务类": ["广告", "文化传媒", "建筑装潢", "设计", "美容美发", "房地产中介", "物业管理", "商务咨询", "企业管理"],
    "其他": ["贸易","实业","制造","服饰","化妆品","工程","农业","餐饮管理","物流"],
}


module.exports = NameAPI;
