var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "addOrder"://创建订单
                opResult = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
                break;
            case "getOrderInfo"://获取订单列表信息
                opResult = await this.utilsOrderSve.getOrderInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDetails"://获取订单详情信息
                opResult = await this.utilsOrderSve.getOrderDetails(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryInfo"://获取订单交付信息
                opResult = await this.utilsOrderSve.getOrderDeliveryInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowInfo"://获取订单交付流程信息
                opResult = await this.utilsOrderSve.getOrderDeliveryFlowInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowList"://获取订单交付流程列表信息
                opResult = await this.utilsOrderSve.getOrderDeliveryFlowList(pobj, pobj.actionBody);
                break;
            case "getOrderLogInfo"://获取订单日志信息
                opResult = await this.utilsOrderSve.getOrderLogInfo(pobj, pobj.actionBody);
                break;
            case "delOrder"://删除订单
                opResult = await this.utilsOrderSve.delOrder(pobj, pobj.actionBody);
                break;
            // case "getIcbcOrderDetails"://获取工商详情
            //     opResult = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
            //     break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;
