var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class Need extends APIBase {
    constructor() {
        super();
        this.utilsNeedSve = system.getObject("service.utilsSve.utilsNeedSve");
        this.centerorderSve = system.getObject("service.common.centerorderSve");
    }

    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_process, action_type, action_body, req) {
        pobj.requestId = req.requestId;
        var self = this;
        var opResult = null;
        switch (action_type) {
            case "submitNeedH5"://提交需求－－－－del
                opResult = await this.utilsNeedSve.submitNeedH5(pobj, pobj.actionBody);
                break;
            //--------------------------------------跟ali合作---------------------------                
            case "submitNeed"://提交需求
                opResult = await this.utilsNeedSve.submitNeed(pobj, pobj.actionBody);
                break;
            case "needClose"://关闭需求
                opResult = await this.utilsNeedSve.needClose(pobj, pobj.actionBody);
                break;
            case "needCloseIcp"://关闭需求
                opResult = await this.utilsNeedSve.needCloseIcp(pobj, pobj.actionBody);
                break;
            case "needDetailByChannelNo":
                opResult = await this.utilsNeedSve.needDetailByChannelNo(pobj, pobj.actionBody);
                break;
            case "getItemByChannelNeedNo":
                opResult = await this.utilsNeedSve.getItemByChannelNeedNo(pobj, pobj.actionBody);
                break;
            case "getItemByNeedNo":
                opResult = await this.utilsNeedSve.getItemByNeedNo(pobj, pobj.actionBody);
                break;
            case "receiveFeedback"://接收方案反馈信息
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj);
                break;
            case "getItemByChannelSolutionNo":
                opResult = await this.utilsNeedSve.getItemByChannelSolutionNo(pobj, pobj.actionBody);
                break;
            case "icpFeedbackSubmit"://icp接收方案反馈信息
                pobj.actionType = "receiveIcpFeedback";
                opResult = await this.utilsNeedSve.reqCenterOrderQcApi(pobj);
                break;
            case "icpNotify"://icp方案更新
                opResult = await this.utilsNeedSve.icpNotify(pobj, pobj.actionBody);
                if (opResult.status == 0 && pobj.actionBody.status == 1) {
                    opResult = await self.centerorderSve.icppaysuccess(pobj, pobj.actionBody);
                }
                break;
            case "writeCommunicationLog"://icp接收方案反馈信息
                opResult = await this.utilsNeedSve.writeCommunicationLog(pobj);
                break;
            case "queryExpertApplyCommunicationLogs"://icp接收方案反馈信息
                opResult = await this.utilsNeedSve.queryExpertApplyCommunicationLogs(pobj);
                break;
            case "getaliicpProduce"://方案询价
                opResult = await this.centerorderSve.getaliicpProduce(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = Need;