var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class PaymentAPI extends WEBBase {
    constructor() {
        super();
        // this.execlient = system.getObject("util.execClient");
        // this.centerAppUrl = settings.centerAppUrl();

        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    }

    /**
     * 接口跳转-POST请求
     * actionProcess  执行的流程
     * actionType     执行的类型
     * actionBody     执行的参数
     */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "getH5PayUrl"://H5端订单支付二维码生成
                opResult = await this.utilsOrderSve.getH5PayUrl(pobj, pobj.actionBody);
                break;
            case "getOrderQrCode"://pc端订单支付二维码生成
                opResult = await this.utilsOrderSve.getOrderQrCode(pobj, pobj.actionBody);
                break;
            case "queryOrderStatus"://通联支付查询
                opResult = await this.utilsOrderSve.queryOrderStatus(pobj, pobj.actionBody);
                break;
            case "getQrCode"://获取pc端支付二维码--不跟订单关联
                opResult = await this.utilsOrderSve.getQrCode(pobj, pobj.actionBody);
                break;
            case "queryOrder"://通联支付查询
                opResult = await this.utilsOrderSve.queryOrder(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = PaymentAPI;
