const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
function exp(db, DataTypes) {
  var base = {
    code: DataTypes.STRING(100),
    app_id: DataTypes.INTEGER,//  
    createuser_id: DataTypes.INTEGER,//                                                                                                                                                                                            
    updateuser_id: DataTypes.INTEGER,// 
    auditoruser_id: DataTypes.INTEGER,//  
    moneyaccount_id: DataTypes.INTEGER,//                                                                                                                                                                                           
    creator: DataTypes.STRING(100),//创建者
    updator: DataTypes.STRING(100),//更新者
    auditor: DataTypes.STRING(100),//审核者
    opNotes: DataTypes.STRING(500),//操作备注
    auditStatusName: {
      type: DataTypes.STRING(50),
      defaultValue: "待审核",
    },
    auditStatus: {//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.audit_status),
      set: function (val) {
        this.setDataValue("auditStatus", val);
        this.setDataValue("auditStatusName", uiconfig.config.pdict.audit_status[val]);
      },
      defaultValue: "dsh",
    },
    sourceTypeName: DataTypes.STRING(50),
    sourceType: {//来源类型 "order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.source_type),
      set: function (val) {
        this.setDataValue("sourceType", val);
        this.setDataValue("sourceTypeName", uiconfig.config.pdict.source_type[val]);
      }
    },
    sourceOrderNo: DataTypes.STRING(100),//来源单号
    channelServiceNo: DataTypes.STRING(100),//渠道服务单号
  };
  return base;
}

module.exports = exp;
