const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
const getRawBody = require('raw-body');
class GatewaypushlogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(GatewaypushlogService));
    this.execClient = system.getObject("util.execClient");
  }

  async taskAliIcapi() {
    try {
      var sql = "select * from gateway_pushlog where pushStatus='wts' and pushtimes<4"
      var icloginfos = await this.customQuery(sql);
      if (icloginfos.length > 0) {
        var count = 10;
        if (icloginfos.length < count) {
          count = icloginfos.length;
        }
        var self = this;
        for (var i = 0; i < count; i++) {
          var icloginfo = icloginfos[i];
          var requestdata = null;
          if (icloginfo && icloginfo.requestjson) {
            requestdata = JSON.parse(icloginfo.requestjson);
          }
          var url = settings.gatewayUrl() + "action/intentionapi/springBoard";
          var rtn = await self.execClient.execPost(requestdata, url);
          var data = JSON.parse(rtn.stdout);
          if (data.success) {
            icloginfo.pushStatus = "yts";
          } else {
            icloginfo.pushtimes += 1;
          }
          await this.update(icloginfo);
        }
      }
      return system.getResultSuccess();

    } catch (error) {
      return system.getResultFail(-1,error);
    }
  }



}
module.exports = GatewaypushlogService;
