const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

class FblicenseService extends AppServiceBase {
  constructor () {
    super();
    this.centerOrderUrl = settings.centerOrderUrl()
    this.restClient = system.getObject("util.restClient")
    this.redisClient = system.getObject("util.redisClient")
  };

  //获取列表、检索
  async getList (pobj) {
    try {
      let url = `${this.centerOrderUrl}action/diagnosisneedbus/springBoard`
      pobj.actionType = 'getList'
      let result = await this.restClient.execPost(pobj, url)
      return JSON.parse(result.stdout)
    } catch (error) {
      return system.getResultFail(-1, error.message || 'failed')
    }
  }

  // 获取详情
  async getDetail (pobj) {
    try {
      let url = `${this.centerOrderUrl}action/diagnosisneedbus/springBoard`
      pobj.actionType = 'getDetail'
      let result = await this.restClient.execPost(pobj, url)
      let data = JSON.parse(result.stdout)
      if (data.status != 0)
        return system.getResultFail(-1, error.message || 'failed')
      return data;
    } catch (error) {
      return system.getResultFail(-1, error.message || 'failed')
    }
  }

  // 认证
  async doEAV (pobj) {
    try {
      let url = `${this.centerOrderUrl}action/diagnosisneedbus/springBoard`
      pobj.actionType = 'doEAV'
      let result = await this.restClient.execPost(pobj, url)
      return JSON.parse(result.stdout)
    } catch (error) {
      return system.getResultFail(-1, error.message || 'failed')
    }
  }

  // 获取需求列表
  async getNeedList (pobj) {
    try {
      let url = `${this.centerOrderUrl}action/diagnosisneedbus/springBoard`
      pobj.actionType = 'getNeedList'
      let result = await this.restClient.execPost(pobj, url)
      return JSON.parse(result.stdout)
    } catch (error) {
      return system.getResultFail(-1, error.message || 'failed')
    }
  }
  // 获取需求详情
  async getNeedDetail (pobj) {
    try {
      let url = `${this.centerOrderUrl}action/diagnosisneedbus/springBoard`
      pobj.actionType = 'getNeedDetail'
      let result = await this.restClient.execPost(pobj, url)
      return JSON.parse(result.stdout)
    } catch (error) {
      return system.getResultFail(-1, error.message || 'failed')
    }
  }

  async licenseCompare (pobj) {
    let key = `${pobj.companyName}_${pobj.picName}`
    let resCache = await this.redisClient.get(key)
    if (resCache) {
      return {
        status: 0,
        msg: "success",
        data: JSON.parse(resCache)
      }
    } else {
      let result = await this.restClient.execPost(pobj, 'http://106.13.228.212/gsb/api/qualificationsDetail')
      result = JSON.parse(result.stdout)
      if (result.status == 0) {
        let result = res.data
        result = this.ObjTrim(result)
        result = {
          许可名称: result.Name,
          许可证编号: result.No,
          有效期自: result.StartDate,
          有效期至: result.EndDate
        }
        // result = {
        //   许可证编号: result.许可证编号,
        //   证照名称: result.证照名称,
        //   有效期限: result.有效期限,
        //   有效期限: result.有效期限,
        //   发证机关: result.发证机关
        // }
        await this.redisClient.setWithEx(key, JSON.stringify(result), 3600);
        return {
          status: 0,
          msg: "success",
          data: result
        }
      } else {
        return {
          status: -1,
          msg: result.message
        }
      }
    }
  }

  ObjTrim (data) {
    let k = Object.keys(data)
    for (let i of k) {
      if (!data[i]) {
        delete data[i]
      }
    }
    console.log(data)
    return data
  }
}

module.exports = FblicenseService;
