var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const { json } = require("sequelize");
//需求操作类----ali对接的需求
class UtilsNeedService extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.aliclient = system.getObject("util.aliyunClient");
    this.ossClient = system.getObject("util.ossClient");
    this.restClient = system.getObject("util.restClient");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.opPushQueueUrl = settings.opPushQueueUrl();
  }

  /**
    * 提交需求
   * @param {*} pobj 
    * @param {*} actionBody 
    */
  async submitNeed(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
    }
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求類型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionType = "submitNeed";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (pobj.actionBody.channel_type_code == "esp.companyreg") {
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      } else {
        if (pobj.actionBody.channel_type_code == 5) {
          pobj.actionBody.type = "ali.icp";
        } else {
          pobj.actionBody.type = "ali.edi";
        }
        var reqParams = {
          actionBody: pobj.actionBody,
          appInfo: pobj.appInfo
        }
        this.utilsPushSve.aliBusiness2Delivery(reqParams, "addChance");

        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedICPBusiness");
      }
    }
    return result;
  }



  //调用center-order  icp需求反馈
  async reqCenterOrderQcApi(pobj, reqUrl) {
    var url = this.centerOrderUrl + "action/qcapi/springBoard";
    if (reqUrl) {
      var url = this.centerOrderUrl + reqUrl;
    }
    var self = this;
    pobj.actionType = "receiveIcpFeedback";
    // 2020 0803 lin 修改;   
    if (pobj.intentionStatus) {
      // 如果需求当前字段为5（已关闭）则通知fq
      if (pobj.intentionStatus == 5) {
        self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
      }
    }
    var rtn = await this.execClient.execPost(pobj, url);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  /**
   * 提交需求-----del
   * @param {*} pobj
   * @param {*} actionBody
   */
  async submitNeedH5(pobj, actionBody) {
    var sobj = pobj;
    sobj.actionType = "getProductTypeInfo";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn = await this.execClient.execPost(sobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResultFail(-5015, "需求类型查询失败");
    }
    var data = JSON.parse(rtn.stdout);
    if (data.status != 0) {
      return system.getResultFail(-5015, "需求类型查询失败");
    }
    pobj.actionBody.type_code = data.data.type_code;
    pobj.actionBody.type_name = data.data.type_name;
    pobj.actionBody.channel_type_code = data.data.channel_type_code;
    pobj.actionBody.channel_type_name = data.data.channel_type_name;
    pobj.actionType = "submitNeedH5";
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (pobj.actionBody.channel_type_code == "esp.companyreg") {
        this.utilsPushSve.aliBusiness2Fq(pobj, "pushNeedBusiness");
      }
      // else{
      //   if(pobj.actionBody.channel_type_code==5){
      //     pobj.actionBody.regType="ali.icp";
      //   }else{
      //     pobj.actionBody.regType="ali.edi";
      //   }
      //   this.utilsPushSve.aliBusiness2Fq(pobj, "intention");
      // }
    }
    return result;
  }

  /**
  * 获取需求详情
 * @param {*} pobj 
  * @param {*} actionBody needNo 需求号
  */
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100385");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取需求详情
 * @param {*} pobj 
  * @param {*} actionBody needNo 需求号
  */
  async getItemByChannelNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 获取需求详情
 * @param {*} pobj 
  * @param {*} actionBody bizId 渠道方案号
  */
  async getItemByChannelSolutionNo(pobj, actionBody) {
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100390");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(pobj, reqUrl);
    return itemResult;
  }
  /**
  * 关闭需求
 * @param {*} pobj 
  * @param {*} actionBody 
  */
  async needClose(pobj, actionBody) {
    if (!actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      this.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "推送失敗　100388");
    }
  }

  /**
  * icp关闭需求
 * @param {*} pobj 
  * @param {*} actionBody 
  */
  async needCloseIcp(pobj, actionBody) {
    if (!actionBody.channelNeedNo) {
      return system.getResult(null, "actionBody.channelNeedNo can not be empty，100395");
    }
    if (!actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100395");
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if (result.status == 0) {
      if (result.data) {
        pobj.actionBody.orderNo = result.data;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }
      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.channelNeedNo,
          status:"closeNeed"
        },
        appInfo: pobj.appInfo
      }
      self.utilsPushSve.aliBusiness2Delivery(reqParams, "updateChanceStatus");

      // 推送ali
      var a = await self.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: actionBody.channelNeedNo, Note: actionBody.note }, apiVersion: "2019-05-08" });
      console.log(a);
      self.utilsPushSve.aliBusiness2Fq(pobj, "pushCloseICPNeed");
      return system.getResultSuccess();
    } else {
      return system.getResult(null, "close fail　100389  ");
    }

  }

  //查询需求详情
  async getItemByNeedNo(pobj, actionBody) {
    if (!actionBody.needNo) {
      return system.getResult(null, "actionBody.needNo can not be empty，100395");
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //状态更新
  async icpNotify(pobj) {
    var actionBody = pobj.actionBody;
    var self = this;
    if (!actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100495");
    }
    actionBody.BizId = actionBody.bizId;
    if (!actionBody.status) {
      return system.getResult(null, "actionBody.status can not be empty，100495");
    }
    if (actionBody.businessLicense) {
      actionBody.newbusinessLicense = await self.opDownFileInfo(actionBody.businessLicense);
    }
    if (actionBody.idCardUrlList) {
      var jsonidCardUrlList = JSON.parse(actionBody.idCardUrlList);
      var newidCardUrlList = [];
      for (var i = 0; i < jsonidCardUrlList.length; i++) {
        var key = jsonidCardUrlList[i];
        newidCardUrlList.push(await self.opDownFileInfo(key));
      }
      actionBody.newidCardUrlList = newidCardUrlList;
    }
    if (actionBody.userPlan) {
      actionBody.newuserPlan = await self.opDownFileInfo(actionBody.userPlan);
    }
    if (actionBody.userForeig) {
      actionBody.newuserForeig = await self.opDownFileInfo(actionBody.userForeig);
    }
    if (actionBody.userLaw) {
      actionBody.newuserLaw = await self.opDownFileInfo(actionBody.userLaw);
    }
    if (actionBody.userOtherList) {
      var jsonuserOtherList = JSON.parse(actionBody.userOtherList);
      var newuserOtherList = [];
      for (var i = 0; i < jsonuserOtherList.length; i++) {
        var key = jsonuserOtherList[i];
        newuserOtherList.push(await self.opDownFileInfo(key));
      }
      actionBody.newuserOtherList = newuserOtherList;
    }
    pobj.actionType = "receiveIcpStatusNotify";
    var url = settings.centerOrderUrl() + "action/qcapi/springBoard";
    var rtn = await this.restPostUrl(pobj, url);
    if (rtn.status == 0 && actionBody.status != 1 && rtn.data) {
      var tmpObj = {
        actionBody: {
          orderNo: rtn.data.orderNo,
          channelNeedNo: rtn.data.channelNeedNo,
          needsolution: rtn.data.solutionContent
        },
        appInfo: pobj.appInfo
      }
      this.utilsPushSve.aliBusiness2Delivery(tmpObj, "pushDeliveryStatusNotify");
      pobj.actionBody.orderNo = rtn.data.orderNo;
      if (actionBody.status == 11) {
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
        tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
        self.utilsPushSve.aliBusiness2Fq(tmpObj, "pushOrderICPClose");
      }
    }//通知更新状态
    return rtn;
  }
  /**
   * 推送交付信息至企业宝（交付系统）
   */
  async pushOrderDelivery2Qfb(pobj, needsolution) {

  }

  async opDownFileInfo(docUrl, result) {  //从oss下载到本地并上传到自己oss，之后删除本地文件
    /*docUrl下载链接，全路径，如：https://XXXXXX.pdf?XXXXX */
    try {
      var tmpFileName = docUrl.substring(0, docUrl.lastIndexOf("?"));
      var fileName = tmpFileName.substr(tmpFileName.lastIndexOf("/") + 1, tmpFileName.lenght);
      // 2020 0803 lin 修改;
      var urlJson = this.urlSplit(docUrl);
      if (urlJson["Expires"]) {
        // url中过期时间与服务器时间对比结果为已过期
        if (urlJson["Expires"] < new Date().getTime()) {
          return "http://gsb-zc.oss-cn-beijing.aliyuncs.com/" + fileName;
        }
      }
      //解码后的文件全名:xxx.pdf
      var fileAllName = decodeURIComponent(fileName);//为xxx.pdf
      var saveFilePath = '/tmp/' + fileAllName;
      // 下载文件到指定的路径
      var tmpp = await this.restClient.execDownload("'" + docUrl + "'", saveFilePath);
      //上传 saveFilePath的文件 到ossClient
      var rtn = await this.ossClient.upfile(fileAllName, saveFilePath);
      result = rtn.url;
      //删除本地文件
      fs.unlink(saveFilePath, function (err) { });
    } catch (e) {

    }
    return result;
  }

  async needDetailByChannelNo(pobj) {
    if (!pobj.actionBody.bizId) {
      return system.getResult(null, "actionBody.bizId can not be empty，100491");
    }
    var solutionobj = {
      actionType: "getIcpProgrammeDetail",
      actionBody: { BizId: pobj.actionBody.bizId },
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var url = this.centerOrderUrl + "action/icpapi/springBoard";
    var solutionrtn = await this.execClient.execPost(solutionobj, url);
    if (!solutionrtn || !solutionrtn.stdout) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    var solutiondata = JSON.parse(solutionrtn.stdout);
    if (solutiondata.status != 0) {
      return system.getResultFail(-5011, "方案查询失败");
    }
    if (solutiondata.data && solutiondata.data[0].channelNeedNo) {
      pobj.actionBody.needNo = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.needId = solutiondata.data[0].channelNeedNo;
      pobj.actionBody.channelSolutionNo = solutiondata.data[0].channelSolutionNo;
    }
    var sobj = {
      actionType: "getItemByChannelNeedNo",
      actionBody: pobj.actionBody,
      appInfo: pobj.appInfo,
      actionProcess: pobj.actionProcess
    }
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var itemResult = await this.restPostUrl(sobj, reqUrl);
    if (itemResult.status == 0) {
      itemResult.data.channelSolutionNo = pobj.actionBody.channelSolutionNo;
    }
    return itemResult;
  }

  async writeCommunicationLog(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    await self.aliclient.reqbyget({ action: "WriteCommunicationLog", reqbody: { BizId: pobj.actionBody.intentionBizId, Note: pobj.actionBody.note }, apiVersion: "2019-05-08" });
    return system.getResultSuccess();
  }

  async queryExpertApplyCommunicationLogs(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100493");
    }
    if (!pobj.actionBody.userFeedBack) {
      return system.getResult(null, "actionBody.userFeedBack can not be empty，100494");
    }
    let res = await this.aliclient.reqbyget({
      action: "QueryExpertApplyCommunicationLogs", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        BizId: pobj.actionBody.intentionBizId,
        UserFeedBack: pobj.actionBody.userFeedBack,
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2019-05-08"
    });
    return system.getResultSuccess(res);
  }

  async test(pobj) {
    
    let res = await this.aliclient.reqbyget({
      action: "QueryTradeIntentionUserList", reqbody: {
        BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
        EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
        BizId: "20200817115056000001",
        Type: "5",
        PageNum: pobj.actionBody.pageNum || 1,
        PageSize: pobj.actionBody.pageSize || 10,
      }, apiVersion: "2019-05-08"
    });
    return system.getResultSuccess(res);
  }


  urlSplit(url) {
    var arr = url.split("?")[1];           //根据？跟个url
    var arr2 = arr[1].split("&");         //根据&重新分割参数
    var jsonarr = {};                    //定义一个json对象放置url  参数
    for (var i = 0; i < arr2.length; i++) {   //循环将参数放到json里面
      jsonarr[arr2[i].substring(0, 1)] = arr2[i].substring(2, 3);
    }
    return jsonarr;
  }
  // async test1() {

  //   var a = await this.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: "20200416125415000001", Note: "测试需求关闭" }, apiVersion: "2019-05-08" });
  //   console.log(a.data);
  //   return a;
  // }
}

module.exports = UtilsNeedService;

// var a=new UtilsNeedService();
// a.queryExpertApplyCommunicationLogs({actionBody:{intentionBizId:"20200803095203000001",userFeedBack:true}});
// // var a=new UtilsNeedService();
// a.writeCommunicationLog({actionBody:{intentionBizId:"20200804200124000001",note:"测试反馈"}});

// var a=new UtilsNeedService();
// a.needCloseIcp({actionBody:{channelNeedNo:20200804200124000001,note:"ceshifankui"}},{channelNeedNo:20200803095203000001,note:"ceshifankui"});

var a=new UtilsNeedService();
a.test({actionBody:{intentionBizId:"20200803095203000001",userFeedBack:true}});


