var url = require("url");
var system = require("../../base/system");
const utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
const logCtl = system.getObject("service.common.oplogSve");
const utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
const utilsFeishuSve = system.getObject("service.utilsSve.utilsFeishuSve");
var md5 = require('md5');
var xml2js = require('xml2js');

module.exports = function (app) {
	//-----------------------新的模式---------web---------开始

	app.use('/tlpay/aliPayNotify', async function (req, res) {
		try {
			var client_ip = system.get_client_ip(req);
			var result = await utilsOrderSve.opH5AliDingPayBackNotify(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录阿里钉钉支付回调处理结果",
				op: "center-channel/tlpay/aliPayNotify",
				content: "支付回调处理结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			if (result.status != 0) {
				return res.end("FAIL");
			}
			return res.end("success");
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "阿里钉钉支付回调处理异常",
				op: "center-channel/tlpay/aliPayNotify",
				content: "回调参数：req=" + JSON.stringify(req) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/tlpay/notify', async function (req, res) {
		try {
			var client_ip = system.get_client_ip(req);
			var result = await utilsOrderSve.receiveCallBackNotify(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果：，method=" + req.body.trxcode,
				op: "center-channel/tlpay/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "回调结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			if (result.status != 0) {
				return res.end("FAIL");
			}
			return res.end("success");
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "center-channel/tlpay/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/tlpay/opBackNotify', async function (req, res) {
		try {
			var client_ip = system.get_client_ip(req);
			var result = await utilsOrderSve.opBackNotify(req.body, client_ip);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "回调处理订单结果：，method=" + req.body.trxcode,
				op: "center-channel/tlpay/opBackNotify",
				content: "回调参数：" + JSON.stringify(req.body) + "回调处理订单结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			res.end(JSON.stringify(result));
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录回调处理结果异常：，method=" + req.body.trxcode,
				op: "center-channel/tlpay/opBackNotify",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	//----------------------飞书小程序---------------------------------------------开始

	//飞书通知
	app.use('/feishu/notify', async function (req, res) {
		try {
			var client_ip = system.get_client_ip(req);
			var result = await utilsFeishuSve.notify(req.body);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "飞书小程序记录回调处理结果,method=notify",
				op: "app/config/routes/api.js/feishu/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "回调结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			var returnObj = JSON.stringify(result);
			return res.end(returnObj);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "飞书小程序记录回调处理结果异常：，method=notify",
				op: "app/config/routes/api.js/feishu/notify",
				content: "回调参数：" + JSON.stringify(req.body) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	app.use('/feishu/login', async function (req, res) {
		try {
			var result = system.getResult(null, "login fail");
			// console.log(req,"/feishu/login++++++++++++++++++++++++++++++++++++++");
			var client_ip = system.get_client_ip(req);
			var pobj = req.query;
			var token = pobj.state || "";
			if (!token) {
				result.msg = "req headers token can not be empty";
				result.data = null;
				res.end(JSON.stringify(result));
				return;
			}
			var cacheManager = system.getObject("db.common.cacheManager");
			var result = await cacheManager["AppTokenByHostsCache"].getCache(token, system.exTime);
			if (result.status != 0) {
				res.end(JSON.stringify(result));
				return;
			}
			pobj.appInfo = result.data;
			result = await utilsFeishuSve.checkAndLogin(pobj);
			logCtl.info({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "飞书小程序记录回调处理结果,method=login",
				op: "app/config/routes/api.js/feishu/notify",
				content: "回调参数：" + JSON.stringify(pobj) + "回调结果：" + JSON.stringify(result),
				clientIp: client_ip || ""
			});
			var returnObj = JSON.stringify(result);
			return res.end(returnObj);
		} catch (error) {
			logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "飞书小程序记录回调处理结果异常：，method=login",
				op: "app/config/routes/api.js/feishu/notify",
				content: "回调参数：" + JSON.stringify(req.query) + "error：" + error.stack,
				clientIp: client_ip || ""
			});
		}
	});
	//----------------------飞书小程序---------------------------------------------结束
	
    // app-ali支付回调通知
    app.use('/orderNotify/aliPayNotify', async function (req, res) {
        try{
            var client_ip = system.get_client_ip(req);
            var result = await utilsOrderSve.aliPayNotify(req.body, client_ip);
            logCtl.info({
                optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录支付宝回调处理结果 api层",
                op: "center-channel/orderNotify/aliPayNotify",
                content: "支付回调处理结果：" + JSON.stringify(result),
                clientIp: client_ip || ""
            });
            if (result.status != 0) {
                return res.end("FAIL");
            }
            return res.end("success");
        } catch(e) {
            logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "支付宝回调处理异常 api层",
				op: "center-channel/orderNotify/aliPayNotify",
				content: "回调参数：req=" + JSON.stringify(req) + "error：" + e.stack,
				clientIp: client_ip || ""
			});
        }
    });
    // app-wx支付回调
    app.use('/orderNotify/wxPayNotify', async function (req, res) {
        try{
            var body = "";

            req.on('data', function(data) {
                body += data;
            });
            req.on('end', async function() {
                xml2js.parseString(body, { trim: true, explicitArray: false, explicitRoot: false }, async function(err, json) {
                    var client_ip = system.get_client_ip(req);
                    var result = await utilsOrderSve.wxPayNotify(json);
                    logCtl.info({
                        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "记录微信支付回调处理结果",
                        op: "center-channel/orderNotify/wxPayNotify",
                        content: "支付回调处理结果：" + JSON.stringify(result),
                        clientIp: client_ip || ""
                    });
                    if (result.status != 0) {
                        return res.end("FAIL");
                    }
                    return res.end("success");
                })
                
            })
        } catch(e) {
            logCtl.error({
				optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "微信回调处理异常",
				op: "center-channel/orderNotify/wxPayNotify",
				content: "回调参数：req=" + JSON.stringify(req) + "error：" + e.stack,
				clientIp: client_ip || ""
			});
        }
    });	
	
	
	app.all("/web/*", async function (req, res, next) {
		var result = system.getResult(null, "req method must is post");
		if (req.method != "POST") {
			res.end(JSON.stringify(result));
			return;
		}
		if (!req.body.actionType) {
			result.msg = "actionType can not be empty";
			res.end(JSON.stringify(result));
			return;
        }
        // 2020 0812 lin 只去掉了check，因为要记录智能诊断的返回值，其他接口暂时未去掉
		if (["getAppTokenByHosts", "getAppTokenByAppKey", "test","getIndustries","getSecondIndustries","getQualificationByIndustry","counselling"].indexOf(req.body.actionType) >= 0) {
			req.body.actionBody.appHosts = req.host;
			next();
			return;
		}
		if (req.body.actionType == "receiveCallBackNotify") {
			req.body.actionBody.app_hosts = req.host;
			next();
			return;
		}
		var token = req.headers["token"] || "";
		if (!token) {
			result.msg = "req headers token can not be empty";
			result.data = null;
			res.end(JSON.stringify(result));
			return;
		}
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppTokenByHostsCache"].getCache(token, system.exTime);
		if (result.status != 0) {
			res.end(JSON.stringify(result));
			return;
		}
		req.body.appInfo = result.data;
		req.body.actionProcess = result.data.app_code;
		var lst = ["serviceProviderSubmitMaterial","closeOrderDelivery","serviceProviderNotification",
			"tmConfirm", "getNeedSolutionDetailByUser","getProgrammeInfoByChannelNeedNo",
			"submitIcpProgramme", "submitIcpMaterial", "acceptIcpPartnerNotification", "abolishIcpProgramme",
			"addOrder", "getH5PayUrl", "getOrderQrCode", "queryOrderStatus", "getOrderInfo", "getOrderDeliveryInfo", "getOrderDetails",
			"getOrderDeliveryFlowInfo", "getOrderDeliveryFlowList", "getOrderLogInfo", "updateContacts", "updateTmOrder", "delOrder",
			"submitProgramme", "getProgrammeListByUser", "getProgrammeInfoByNeedNo", "abolishProgramme", "getAliPayInfo",
            "getPaidLogoListByUser","getCollectibleLogoListByUser","collectLogo","getLogoMaterial","cancelCollectLogo","icpNotify","createName","getNameDetail","orderConfirm",
            "orderTotalSum", "collect", "reg", "orderCheck","getReOrderList","getOfficalList","addReviewList","opSubmitNeed","opNeedClose","opNeedList","getItemByNeedNo","opNeedDetailByChannelNo",
            "getNeedListUser",
            "manualEvaluation", "diagnosisInfo", "check", "enterpriseInfo", "diagnosisDetail"
		];
		if (lst.indexOf(req.body.actionType) >= 0) {
			var userpin = req.headers["userpin"] || "";
			if (!userpin) {
				result.status = system.noLogin;
				result.msg = "req headers userpin can not be empty";
				result.data = null;
				res.end(JSON.stringify(result));
				return;
			} else {
				var params = {
					"appInfo": req.body.appInfo,
					"actionType": "getLoginInfo",
					"actionBody": {
						"userpin": userpin
					}
				}
				result = await utilsAuthSve.getLoginInfo(params, params.actionBody);
				if (result.status != 0) {
					result.status = system.noLogin;
					result.msg = "user login is invalidation";
					res.end(JSON.stringify(result));
					return;
				}
				req.body.userInfo = result.data;
			}
		}//需要用户登录
		next();
	});

	app.get('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];

		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.clientIp = tClientIp; req
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		var params = [];
		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});

	//-----------------------新的模式---------web---------结束

	//-----------------------新的模式---------api---------开始

	app.all("/api/*", async function (req, res, next) {
		var result = system.getResult(null, "req method must is post");
		if (req.method != "POST") {
			res.end(JSON.stringify(result));
			return;
		}
		if (["getAppTokenByHosts", "getAppTokenByAppKey"].indexOf(req.body.actionType) >= 0) {
			req.body.actionBody.appHosts = req.host;
			next();
			return;
		}
		if (req.path.indexOf("/taskapi/") >= 0) {
			next();
			return;
		}
		if (!req.body.actionType) {
			result.msg = "actionType can not be empty";
			res.end(JSON.stringify(result));
			return;
		}
		var token = req.headers["token"] || "";
		if (!token) {
			result.msg = "req headers token can not be empty";
			result.data = null;
			res.end(JSON.stringify(result));
			return;
		}
		var cacheManager = system.getObject("db.common.cacheManager");
		var result = await cacheManager["AppTokenByHostsCache"].getCache(token, system.exTime);
		if (result.status != 0) {
			res.end(JSON.stringify(result));
			return;
		}
		req.body.appInfo = result.data;
		req.body.actionProcess = result.data.app_code;
		var lst = [
			"submitNeed", "paySuccess","icpNotify"
		];
		if (lst.indexOf(req.body.actionType) >= 0) {
			var userpin = req.headers["userpin"] || "";
			if (!userpin) {
				result.status = system.noLogin;
				result.msg = "req headers userpin can not be empty";
				result.data = null;
				res.end(JSON.stringify(result));
				return;
			} else {
				var params = {
					"appInfo": req.body.appInfo,
					"actionType": "getLoginInfo",
					"actionBody": {
						"userpin": userpin
					}
				}
				result = await utilsAuthSve.getLoginInfo(params, params.actionBody);
				if (result.status != 0) {
					result.status = system.noLogin;
					result.msg = "user login is invalidation";
					res.end(JSON.stringify(result));
					return;
				}
				req.body.userInfo = result.data;
			}
		}//需要用户登录
		next();
	});

	app.get('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];

		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.clientIp = tClientIp; req
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		var params = [];
		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});

	//-----------------------新的模式---------api---------结束
};