<a name="menu" href="/doc">返回主目录</a>
1. [下需求](#opSubmitNeed)
2. [需求关闭](#opNeedClose)
3. [需求列表](#opNeedList)
4. [需求详情](#getItemByNeedNo)

## **<a name="opSubmitNeed"> 下需求</a>**
[返回到目录](#menu)
##### URL
[/web/action/opNeed/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：opSubmitNeed

|参数名 |  必须 | 字段类型 | 说明 |
|  ----  | ----  |  ----  | ----  |
|userName | Y | string | 用户名称 |
|area | N | string | 地区名称 |
|description | Y | string | 备注/抖音用做需求类型 |
|mobile | Y | string | 用户电话 |
|type | N | int | 产品类型 |

``` javascript
{
    "actionType":"opSubmitNeed",
    "actionBody":{
        "area": "北京市-北京市-大兴区",
		"description": "公司注册 - ",
		"mobile": "13911391996",
		"type": "gszc",
		"userName": ""
    }
}

```

#### 返回结果
``` javascript
    {
    "status": 0,
    "msg": "success",
    "data": {
        "needNo": "N202008120920C5NEHz9",
    },
    "requestId": "5579e010573b430ebf4b456156061081"
}
```

## **<a name="opNeedClose"> 需求关闭</a>**
[返回到目录](#menu)
##### URL
[/web/action/opNeed/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：opNeedClose

|参数名 |  必须 | 字段类型 | 说明 |
| ----  | ----  |  ----  | ---- |
|needNo | Y | string | 需求号|
|note | N | string | 备注|

``` javascript
    {
    "actionType":"opNeedClose",
    "actionBody":{
        "needNo": "N202008120920C5NEHz9", 
		"note":"不想买了"
    }
}
```

#### 返回结果
``` javascript
    {
        "status": 0,
        "msg": "success",
        "data": null,
        "requestId": "d8ff1ec957e8473f863e79ad91440c60"
    }
```

## **<a name="opNeedList"> 需求列表</a>**
[返回到目录](#menu)
##### URL
[/web/action/opNeed/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：opNeedList

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| pageNumber  | 否 |  string   | 页码  |
| pageSize  | 否 |  string   | 页面大小  |
| status  | 否 |  string   | 状态注意支持类型 'wts', 'yts', 'ygj', 'ygb', 'ycd' |
| needNo  | 否 |  string   | 需求号  |
| publishName  | 否 |  string   | 联系人/公司名称  |
| publishMobile  | 否 |  string   | 联系电话  |
| stdate/endate  | 否 |  string   | 起始/截止时间  |
| consultType  | 否 |  string   | 需求类型  |

``` javascript
{
    "actionType":"opNeedList",
    "actionBody":{
        "pageNumber":"1",
        "pageSize":"10",
        "consultType":"gszc"
    }
}
    
```

#### 返回结果
``` javascript
    // 返回字段需要根据原型来做，目前只返回基础数据
    {
    "status": 0,
    "msg": "success",
    "data": {
        "count": 2,
        "rows": [
            {
                "id": 2846,
                "uapp_id": 22,
                "channelNeedNo": "N202008111937PK2R1ld",
                "needNo": "N202008111937PK2R1ld",// 需求号
                "channelUserId": "15010929366",
                "publishName": "",// 联系人 公司名称
                "publisherOnlyCode": null,
                "publishContent": "公司注册 - ",
                "publishMobile": "13911391996",// 联系电话
                "followManUserId": null,
                "followManName": null,
                "followManMobile": null,
                "followManOnlyCode": null,
                "followContent": null,
                "productOneType_id": null,
                "productType_id": null,
                "notes": null,// 抖音用做需求类型
                "disposeNotes": null,// 备注
                "statusName": "未推送",// 需求状态
                "status": "wts",// 需求状态 wts未推送,yts已推送,ygj已跟进,ycd已成单,ygb已关闭 注意这里原型的需求状态不支持，按文档来
                "city": "北京市-北京市-大兴区",
                "province": null,
                "typeCode": "gszc",
                "typeName": "公司注册",// 需求类型
                "channelTypeCode": "gszc",
                "channelTypeName": "公司注册",
                "created_at": "2020-08-11T11:37:48.000Z",
                "updated_at": "2020-08-11T11:37:48.000Z",// 更新时间
                "deleted_at": null,
                "version": 0
            },
            {
                "id": 2845,
                "uapp_id": 22,
                "channelNeedNo": "N202008111825jPFPjyw",
                "needNo": "N202008111825jPFPjyw",
                "channelUserId": "15010929366",
                "publishName": "",
                "publisherOnlyCode": null,
                "publishContent": "公司注册 - ",
                "publishMobile": "13911391996",
                "followManUserId": null,
                "followManName": null,
                "followManMobile": null,
                "followManOnlyCode": null,
                "followContent": null,
                "productOneType_id": null,
                "productType_id": null,
                "notes": null,
                "disposeNotes": null,
                "statusName": "未推送",
                "status": "wts",
                "city": "北京市-北京市-大兴区",
                "province": null,
                "typeCode": "gszc",
                "typeName": "公司注册",
                "channelTypeCode": "gszc",
                "channelTypeName": "公司注册",
                "created_at": "2020-08-11T10:25:26.000Z",
                "updated_at": "2020-08-11T10:25:26.000Z",
                "deleted_at": null,
                "version": 0
            }
        ]
    },
    "requestId": "ffe3d8ad5ea246bc81ee8d93c6bb0c6e"
}
```

## **<a name="getItemByNeedNo"> 需求详情</a>**
[返回到目录](#menu)
##### URL
[/web/action/opNeed/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：getItemByNeedNo

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| needNo  | 是 |  string   | 需求号  |

``` javascript
{
    "actionType":"getItemByNeedNo",
    "actionBody":{
        "needNo": "N202008120920C5NEHz9"
    }
}
    
```


#### 返回结果
``` javascript
    // 返回字段需要根据原型来做，目前只返回基础数据
    {
    "status": 0,
    "msg": "success",
    "data": {
        "id": 2848,
        "uapp_id": 22,
        "needNo": "N202008120920C5NEHz9",// 需求号
        "channelNeedNo": "N202008120920C5NEHz9",
        "channelUserId": "15010929366",
        "followManUserId": null,
        "followManMobile": null,
        "city": "北京市-北京市-大兴区",
        "province": null,
        "publishContent": "公司注册 - ",// 需求内容
        "publishName": "",// 联系人/公司名称
        "publishMobile": "13911391996",// 联系电话
        "notes": null,// 备注/抖音用做需求类型
        "followContent": null,
        "disposeNotes": null,
        "status": "ygb",// 需求状态 wts未推送,yts已推送,ygj已跟进,ycd已成单,ygb已关闭 注意这里原型的需求状态不支持，按文档来
        "statusName": "已关闭"// 需求状态
        "typeCode": "gszc",// 需求类型
        "typeName": "公司注册",// 需求类型
        "channelTypeCode": "gszc",
        "channelTypeName": "公司注册",
        "publisherOnlyCode": null,
        "followManName": null,
        "followManOnlyCode": null
        "createdAt" // 创建时间
    },
    "requestId": "b8c105d8015b4d1eb9fd3c016ca7b21f"
}
```

