var WEBBase = require("../../web.base");
var system = require("../../../system");
class IcbcToolsAPI extends WEBBase {
    constructor() {
        super();
        this.icbcSve = system.getObject("service.trademark.icbcSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            case "getCompanyListByVague"://企业模糊查询
                opResult = await this.icbcSve.getCompanyListByVague(action_body, req);
                break;
            case "getDetailByCompanyName"://企业详情
                opResult = await this.icbcSve.getDetailByCompanyName(action_body, req);
                break;
            case "getCompanyChangeByName"://企业变更记录查询
                opResult = await this.icbcSve.getCompanyChangeByName(action_body, req);
                break;
            case "getCompanyIcpByName"://工商icp证照查询
                opResult = await this.icbcSve.getCompanyIcpByName(action_body, req);
                break;
            case "searchCertification"://企业证书查询
                opResult = await this.icbcSve.searchCertification(action_body,req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcbcToolsAPI;