var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class QcAPI extends APIBase {
    constructor() {
        super();
        this.qcCenterOrderSve = system.getObject("service.common.qcCenterOrderSve");
        this.baseOrderSve = system.getObject("service.common.baseCenterOrderSve");
        this.ncSve = system.getObject("service.common.ncSve");
        this.rtSve = system.getObject("service.common.rtSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getNeedSolutionDetailByUser"://获取方案详情
                opResult = await this.qcCenterOrderSve.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
                break;
            case "submitIcpProgramme"://icp方案提交
                opResult = await this.baseOrderSve.submitIcpProgramme(pobj);
                break;
            case "receiveProgrammeNo"://接收渠道方案号（测试）
                opResult = await this.qcCenterOrderSve.reqCenterOrderApi(pobj);
                break;
            // case "submitIcpMaterial"://icp材料提交
            //     opResult = await this.qcCenterOrderSve.submitIcpMaterial(pobj);
            //     break;
            // case "acceptIcpPartnerNotification"://icp通知状态变更
            //     opResult = await this.qcCenterOrderSve.acceptIcpPartnerNotification(pobj);
            //     break;
            case "abolishIcpProgramme"://服务商icp方案关闭
                opResult = await this.qcCenterOrderSve.abolishIcpProgramme(pobj);
                break;
            case "getProgrammeInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.qcCenterOrderSve.reqCenterOrderApi(pobj, "action/qcapi/springBoard");
                break;
            case "serviceProviderSubmitMaterial"://交付商提交材料信息
                opResult = await this.baseOrderSve.serviceProviderSubmitMaterial(pobj);
                break;
            case "serviceProviderNotification"://交付商通知状态变更
                opResult = await this.baseOrderSve.serviceProviderNotification(pobj);
                break;
            case "closeOrderDelivery"://交付商关闭交付单
                opResult = await this.qcCenterOrderSve.closeOrderDelivery(pobj);
                break;

            // --------- 网文 ---------

            case "ncSubmitMaterial"://交付材料提交(网文)2020-11-11
                opResult = await this.ncSve.ncSubmitMaterial(pobj);
                break;
            case "ncNotification"://状态通知(网文)2020-11-11
                opResult = await this.ncSve.ncNotification(pobj);
                break;
            case "ncSubmitSolution"://提交方案(网文)2020-11-11
                opResult = await this.ncSve.ncSubmitSolution(pobj);
                break;
            

            // --------- 广电 ---------

            case "rtSubmitMaterial"://交付材料提交(广电)2020-11-11
                opResult = await this.rtSve.rtSubmitMaterial(pobj);
                break;
            case "rtNotification"://状态通知(广电)2020-11-11
                opResult = await this.rtSve.rtNotification(pobj);
                break;
            case "rtSubmitSolution"://提交方案(广电)2020-11-11
                opResult = await this.rtSve.rtSubmitSolution(pobj);
                break;

                // --------- 推送icp信息至渠道和作方 zhuangbing-20201116--------
            case "pushIcpSolution2Channel"://推送ICP方案至渠道（百度）
                opResult = await this.baseOrderSve.pushIcpSolution2Channel(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = QcAPI;