const system = require("../../../system")
const settings = require("../../../../config/settings")
const md5 = require("MD5");
class SignService{
  constructor() {
    this.centerAppUrl = settings.centerAppUrl();
    this.restClient = system.getObject("util.restClient");
    this.redisClient = system.getObject("util.redisClient");
  }
  async restPostUrl(pobj, url) {
    try {
      var rtn = await this.restClient.execPost(pobj, url);
      if (!rtn || !rtn.stdout) {
        return system.getResult(null, "restPost data is empty");
      }
      var result = JSON.parse(rtn.stdout);
      return result;
    } catch (e) {
      var errorMsg = "error：" + e.stack;
      return system.getResult(null, errorMsg);
    }
  }
  async getAppInfoByAppKey(appkey){
    try {
        var shaStr = "getAppInfoByAppKey_"+appkey;
        var cacheRes = await this.redisClient.get(shaStr);
        if (cacheRes) {
            return JSON.parse(cacheRes);
        }
        let url = this.centerAppUrl + 'payment/paymentApi/getAppInfoByAppKey';
        let appInfoRt = await this.restPostUrl({ appKey: appkey }, url);
        if(appInfoRt && appInfoRt.status==0){
            //保存缓存
            await this.redisClient.setWithEx(shaStr, JSON.stringify(appInfoRt), 3600);
        }
        return appInfoRt;
    } catch (error) {
        var errres = system.getResultFail("获取应用信息失败！");
        return errres;
    }
  }
  /**
    * 验证签名
    * @param {*} params 要验证的参数 
    * @param {*} app_secret 应用的校验key
    */
   async verifySign(params, app_secret) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    delete params.requestId;
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey]) {
        let tmpKeyValue = params[tKey];
        if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
          tmpKeyValue = JSON.stringify(tmpKeyValue);
        }
        signArr.push(tKey + "=" + tmpKeyValue);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_secret;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    // console.log("----------------resultSignStr start");
    // console.log(resultSignStr)
    // console.log("----------------resultSignStr end");
    // console.log("----------------resultTmpSign start");
    // console.log(resultTmpSign)
    // console.log("----------------resultTmpSign end");
    // console.log("----------------params.sign start");
    // console.log(params.sign)
    // console.log("----------------params.sign end");
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
   }
   async createSign(params, app_key) {
    if (!params) {
      return system.getResultFail(-310, "请求参数为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResultFail(-330, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey]) {
        let tmpKeyValue = params[tKey];
        if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
          tmpKeyValue = JSON.stringify(tmpKeyValue);
        }
        signArr.push(tKey + "=" + tmpKeyValue);
      }
    }
    if (signArr.length == 0) {
      return system.getResultFail(-350, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    return system.getResultSuccess(resultTmpSign);
  }
}
module.exports = SignService;

// var task = new SignService();
// var obj = {
//   "actionType": "serviceProviderSubmitMaterial",
//     "actionBody": {
//       "uapp_id":44,
//       "isTest":1,
//       "orderNo":"OT442020112419480gtI",
//       "material":{
//         "BusinessLicense":{
//           "Address":"x",
//           "BusinessTerm":"x-x",
//           "CreatedAt":"2020-11-17",
//           "EnterpriseCode":"x",
//           "LegalRepresentative":"x",
//           "Name":"测试 百度渠道",
//           "RegisteredCapital":"10",
//           "ScopeBusiness":"x",
//           "Type":"x"
//         },
//         "Domain":"x.com",
//         "CorporateName":"x",
//         "IncludeForeignInvestment":true,
//         "PartnerBusinessLicense":"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_3610160464935869220206155558692.jpeg",
//         "PartnerIdCardList":["https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_463101604649363092202061556392.jpeg"],
//         "PartnerDomainCertificate":"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_4481016046493695182020615569518.jpeg",
//         "PartnerPreviewOtherList":["https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_24710160464940618020206155646180.zip"]
//       }
//    }
// }
// task.createSign(obj,"7cbb892450174167b5c7e01we4716t51").then(d=>{
//     console.log(d,"!!!!!!!!!!!!!!!!!!!!!!!!!!");
// });

// var obj = {
// 	"orderNo":"c76a7c1a0cf747db92e9fc6beab770f0",
// 	"remark":"lin"
// }

// var obj = {
// 	"bizId":"202011031421",
// 	"status":"16"
// }
// var obj = {
//   "bizId": "OD2020111241779233",
//   "companyInfo": {
//       "corpName": "上海王勇商务软件系统有限公司",
//       "taxpayerTypeEnum": "NORMAL_TAXPAYER",
//       "acctgSystemId": "10008",
//       "enterpriseFormEnum": "OTHERS",
//       "taxIndustryId": 10000,
//       "taxNo": "91310114772112002K",
//       "serviceTypeEnum": "ACCOUTING",
//       "taxClaimMethodEnum": "TAX_DECLARATION"
//   },
//   "contactMobile": "16710500888",
//   "contactName": "王勇",
//   "quantity": 1,
//   "timeUnit": "year"
// }

// }
// task.createSign(obj,"7cbb892450174167b5c7e01we4717z51").then(d=>{
//     console.log(d,"!!!!!!!!!!!!!!!!!!!!!!!!!!");
// });