const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

class IcbcService extends AppServiceBase {
  constructor() {
    super();
    this.zcApiUrl = settings.reqZcApi();
    this.certificationUrl = settings.certificationUrl();
    this.restClient = system.getObject("util.redisClient");
    //处理企业资质证书数据
    this.disposeCertificationData = "disposeCertificationData";
    //企业资质证书查询
    this.searchCertificationData = "searchCertificationData";
  }
  //企业模糊查询
  async getCompanyListByVague(obj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCompanyListByVague";
    return await this.opReqResult(url, obj, req);
  }
  //企业详情
  async getDetailByCompanyName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getDetailByCompanyName";
    return await this.opReqResult(url, queryobj, req);
  }
  //企业变更记录查询
  async getCompanyChangeByName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCompanyChangeByName";
    return await this.opReqResult(url, queryobj, req);
  }
  //工商icp证照查询
  async getCompanyIcpByName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCompanyIcpByName";
    return await this.opReqResult(url, queryobj, req);
  }

  //企业证书查询
  async searchCertification(queryobj, req) {
    if (!queryobj.companyName) {
      return system.getResultFail(-1, 'companyName can not be empty');
    }
    var hashValue = await this.restClient.hget(this.searchCertificationData, queryobj.companyName);
    if (hashValue) {
      return system.getResultSuccess(JSON.parse(hashValue));
    }
    let url = this.certificationUrl + "gsb/SearchCertification";
    let data = {
      "company_name": queryobj.companyName,
      "pageSize": 20,
      "pageIndex": 1,
      "isExactlySame": "True"
    }
    let result = await this.opReqResult(url, data, req);
    if (!result) {
      return system.getResultFail(-1, '查询失败！！！');
    }
    if (result.Status != 200) {
      return system.getResultFail(-1, '查询失败');
    }
    //对结果处理
    // "Tag": 1为qichacha,0为gsb
    var setValue = {};
    setValue[queryobj.companyName] = JSON.stringify(result.Result);
    if (result.Tag == 1) {
      this.restClient.hmset(this.disposeCertificationData, setValue);
    }
    this.restClient.hmset(this.searchCertificationData, setValue);
    return system.getResult(result.Result);
  }


  async opReqResult(reqUrl, queryobj, req) {
    var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"], req.headers["request-id"]);
    var data = JSON.parse(rtn.stdout);
    return data;
  }
}
module.exports = IcbcService;

