var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//产品操作类
class UtilsProductService extends AppServiceBase {
  constructor() {
    super();
  }

  //--------------------------------应用中心获取产品信息-start-----------------------------------------------------


  /**
   * 通过产品类别编码路径获取产品列表
   * @param {*} pobj 
   * @param {*} actionBody pathCode 为类别编码路径，一级类下产品列表 sbfu，二级类下产品列表sbfu/sbzc
   */
  async getProductList(pobj, actionBody) {
    if (!actionBody.pathCode) {
      return system.getResult(null, "actionBody.pathCode can not be empty，100330");
    }
    if(actionBody.name){
      pobj.actionBody.productName = actionBody.name;
    }
    pobj.actionBody.pathCode = "/" + actionBody.pathCode + "/";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }

  /**
   * 获取产品列表及最低价
   * @param pobj
   * @param actionBody
   * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any>}
   */
  async getProductListH5(pobj, actionBody) {
    if (!actionBody.pathCode) {
      return system.getResult(null, "actionBody.pathCode can not be empty，100330");
    }
    pobj.actionType = 'getProductList';
    pobj.actionBody.pathCode = "/" + actionBody.pathCode + "/";
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    let list = await this.restPostUrl(pobj, url);
    if(!list.data){
      return system.getResult(null,'product data is empty')
    }
    for(let item of list.data){
      pobj.actionType = 'getMinPrice';
      pobj.actionBody = {
        product_id:item.product_id
      }
      let re = await this.restPostUrl(pobj,url);
      item.price = re.data ? re.data.price : 0;
    }
    return list;
  }
  /**
   * 获取产品详情
  * @param {*} pobj 
   * @param {*} actionBody channelItemCode 渠道产品编码
   */
  async getProductDetail(pobj, actionBody) {
    if (!actionBody.channelItemCode) {
      return system.getResult(null, "actionBody.channelItemCode can not be empty，100340");
    }
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }

  //--------------------------------应用中心获取产品信息--end----------------------------------------------------

  /**
   * 产品询价
   * @param pobj.actionType ='getProductPrice'
   * @param actionBody
   * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}>}
   */
  async getProductPrice(pobj,actionBody){
    pobj.actionType = 'getProductPrice'
    let url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }

  /**
   * 产品询价baidu gongshang 
   * @param pobj.actionType ='getRegProducePrice'
   * @param actionBody
   * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}>}
   */
  async getRegProducePrice(pobj,actionBody){
    pobj.actionType = 'getRegProducePrice'
    let url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj, url);
  }
  /**
   * 获取推荐产品
   * @param pobj
   * @param actionBody
   * @returns {Promise<void>}
   */
  async getProductRecommend(pobj,actionBody){
    const type = actionBody.type;
    if(!type){
      return system.getResult(-1,'type can be not empty')
    }
    switch (type) {
      case 1:
        if(!actionBody.companyName){
          return system.getResultFail(-1,'companyName can be not empty')
        }
        break;
      case 2:
        if(!actionBody.companyName){
          return system.getResultFail(-1,'companyName can be not empty')
        }
        if(!actionBody.productCode){
          return system.getResultFail(-1,'productCode can be not empty')
        }
        break;
      case 3:
        if(!actionBody.productCode){
          return system.getResultFail(-1,'productCode can be not empty')
        }
        break;
      default:
        return system.getResultFail(-1,'type 参数错误');
    }
    let url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj,url);
  }

  /**
   * 修改产品销售价格
   * @param pobj
   * @param actionBody
   * @returns {Promise<void>}
   */
  async updateProductPrice(pobj,actionBody){
    if(!actionBody.data || actionBody.data.length == 0){
      return system.getResultFail(-1,'data is empty!');
    }
    let url = settings.centerAppUrl() + "action/opProduct/springBoard";
    return await this.restPostUrl(pobj,url);
  }
}
module.exports = UtilsProductService;

