var system = require("../../../system");
const CtlBase = require("../../ctl.base");
class CompanycaseCtl extends CtlBase {
    constructor() {
        super("delivery", CtlBase.getServiceName(CompanycaseCtl));
    }

    // 提交材料
    async submitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.submitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
    // 工商通用产品 提交材料
    async companyCaseDeliverCommonSubmitMaterials(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.companyCaseDeliverCommonSubmitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
    // 工商通用产品 提交交付物
    async companyCaseDeliverCommonSubmitQualification(pobj, qobj, req) {
        try {
            if (!pobj.deliver_id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.companyCaseDeliverCommonSubmitQualification(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }


    // 更改状态
    async changeDeliveryStatus(pobj, qobj, req) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误")
            }
            const rs = await this.service.changeDeliveryStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = CompanycaseCtl;
