var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const moment = require("moment");
class DeliverCtl extends CtlBase {
    constructor() {
        super("delivery", CtlBase.getServiceName(DeliverCtl));
    }
    //修改备注
  async updateRemarkByDeliverCode(mobj, qobj, req) {
    var pobj = mobj.d;
    console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    await this.service.updateRemarkByDeliverCode(pobj)
    return system.getResult("操作成功！"); 
  }
 
    async findAndCountAll(pobj, qobj, req) {
        //设置查询条件
        const rs = await this.service.findAndCountAll(pobj);
        let result = [];
        for (let val of rs.results.rows) {
            val.company_name = val.delivery_info.companyName;
            val.customer_number = val.delivery_info.contactsPhone;
            val.customer_name = val.delivery_info.contactsName;
            val.service_address = val.delivery_info.serviceName;
            val.updated_at = moment(val.updated_at).format('YYYY-MM-DD HH:mm:ss');
            val.created_at = moment(val.created_at).format('YYYY-MM-DD HH:mm:ss');
            if (val.delivery_status === system.ANNUALREPORT.TAKEEFFECT) {
                val.delivery_status = val['annualreports.status'] || system.ANNUALREPORT.WAITDECLARE;
            }
            val.v_action_type = val.v_action_type || "新办"
            val.source_name = system.SOURCENAME[val.source_name] || val.source_name;
            val.salesman_name = val.salesman_opcode ? val.salesman_name : (val.salesman_phone || val.salesman_name)
            val.selling_price = val.selling_price / 100
            result.push(val);
        }
        rs.results.rows = result;
        return system.getResult(rs);
    }
    // 查询 详情
    async findInfo(pobj, qobj, req) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            const rs = await this.service.findInfo(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    async temporarySave(pobj, qobj, req) {
        if (!pobj.deliver_id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.temporarySave(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    async findTemporary(pobj, qobj, req) {
        if (!pobj.deliver_id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        const rs = await this.service.findTemporary(pobj);
        return system.getResultSuccess(rs);
    }

    // 提交材料
    async submitMaterials(pobj, qobj, req) {
        //TODO:各种参数校验
        if (!pobj.deliver_id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.submitMaterials(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    async changeDeliveryStatus(pobj, qobj, req) {
        if (!pobj.id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.changeDeliveryStatus(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    async addQualification(pobj, qobj, req) {
        if (!pobj.deliver_id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.addQualification(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async closeDeliver(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            let rs = await this.service.closeDeliver(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async addMail(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            let rs = await this.service.addMail(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async findAnnualReportInfo(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            const rs = await this.service.findAnnualReportInfo(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }

    async declareReport(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        if (!pobj.file || !pobj.file.url) {
            return system.getResult(null, "file can not be empty，100290");
        }

        try {
            const rs = await this.service.declareReport(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async toCollecting(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.toCollecting(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async toUpload(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "id  can not be empty，100290");
        }
        try {
            let rs = await this.service.toUpload(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async findRelationOrder(pobj) {
        if (!pobj.id) {
            return system.getResult(null, "deliver_id  can not be empty，100290");
        }
        try {
            let rs = await this.service.findRelationOrder(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }

    async changeSalesman(pobj) {
        try {
            let rs = await this.service.changeSalesman(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)
        }
    }
}
module.exports = DeliverCtl;
