const Dao = require("../../dao.base");
class NewMaterialDao extends Dao {
    constructor() {
        super(Dao.getModelName(NewMaterialDao));
    }

    async createOrUpdate(pobj, t) {
        const materialData = await this.findOne({
            deliver_id: pobj.deliver_id
        });
        let result = {};
        let dataInfo = {
            materialInfo: pobj.cache_info,
            deliver_id: pobj.deliver_id,
        }
        if (materialData) {
            //更新
            await this.updateByWhere(dataInfo, {
                deliver_id: pobj.deliver_id
            }, t);
            result = { id: materialData.id }
        } else {
            // 创建
            let data = await this.create(dataInfo, t);
            result = { id: data.id };
        }
        return result
    }

}
module.exports = NewMaterialDao;
