/**
 * 会计表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("accounting", {
        name: { // 姓名
            allowNull: false,
            type: DataTypes.STRING
        },
        agentAccountId: { //易代账ID
            allowNull: false,
            type: DataTypes.STRING
        },
        accAccount: { //会计账号
            allowNull: false,
            type: DataTypes.STRING
        },
        sex: { //性别
            allowNull: true,
            type: DataTypes.STRING
        },
        age: { //年龄
            allowNull: true,
            type: DataTypes.STRING
        },
        mobile: { //电话
            allowNull: true,
            type: DataTypes.INTEGER
        },
        accCode: { //会计组织的code
            allowNull: true,
            type: DataTypes.STRING
        },
        accName: { //会计组织名称
            allowNull: true,
            type: DataTypes.STRING,
            defaultValue: ""
        },
        accaddress: { //会计组织地址
            allowNull: true,
            type: DataTypes.STRING,
            defaultValue: ""
        },
        workingYears: { // 工作年限
            allowNull: true,
            type: DataTypes.STRING
        },
        accCredentials: { // 会计证书：初级会 计、中级会计、高 级会计师、注册会 计师、注册税务师、 ACCA、CMA
            allowNull: true,
            type: DataTypes.JSON
        },
        note: { //其他信息
            allowNull: true,
            type: DataTypes.STRING
        }

    }, {
        paranoid: false, //假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        tableName: 'accounting',
        validate: {},
        indexes: []
    });
}