/**
 * 账套表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("accountset", {
        manageId: { // 工作台管理ID
            allowNull: false,
            type: DataTypes.STRING
        },
        custName: { //客户名称
            allowNull: false,
            type: DataTypes.STRING
        },
        code: { //助记码
            allowNull: true,
            type: DataTypes.STRING
        },
        corpAddress: { //公司地址
            allowNull: true,
            type: DataTypes.STRING
        },
        opsCertificate: { //营业执照
            allowNull: true,
            type: DataTypes.STRING
        },
        legalRepresentative: { //法人
            allowNull: true,
            type: DataTypes.STRING
        },
        legalRepresentativeSsn: { //法人身份证号
            allowNull: true,
            type: DataTypes.STRING
        },
        contactName: { //联系人
            allowNull: true,
            type: DataTypes.STRING
        },
        contactTel: { //联系方式
            allowNull: true,
            type: DataTypes.STRING
        },
        corpName: { //企业名称
            allowNull: false,
            type: DataTypes.STRING
        },
        taxiationArea: { //报税地区
            allowNull: false,
            type: DataTypes.STRING
        },
        taxIndustryId: { //行业
            allowNull: false,
            type: DataTypes.STRING
        },
        serviceTypeEnum: { //服务类型：枚举型，包括ACCOUTING-记账服务、INDUSTRY_COMMERCE-工商服务、BOTH-记账与工商服务。
            allowNull: false,
            type: DataTypes.STRING
        },
        taxNo: { //税号
            allowNull: false,
            type: DataTypes.STRING
        },
        certDueDate: { //证书到期日
            allowNull: true,
            type: DataTypes.STRING
        },
        taxCpNo: { //计算机代码
            allowNull: true,
            type: DataTypes.STRING
        },
        hasTaxCtrl: { //是否有税控机
            allowNull: true,
            type: DataTypes.BOOLEAN,
            defaultValue: false
        },
        taxClaimTypeEnum: { //所得税申报类型：枚举型，包括NATIONAL-国税、LOCAL-地税
            allowNull: true,
            type: DataTypes.STRING
        },
        taxDep: { //税管所
            allowNull: true,
            type: DataTypes.STRING
        },
        taxManager: { //专管员
            allowNull: true,
            type: DataTypes.STRING
        },
        taxPhone: { //税务联系电话
            allowNull: true,
            type: DataTypes.STRING
        },
        comments: { //备注
            allowNull: true,
            type: DataTypes.STRING
        },
        accountantEmployeeId: { //所属会计
            allowNull: false,
            type: DataTypes.STRING
        },
        taxClaimMethodEnum: { //申报方式：TAX_DECLARATION-税款申报；ZERO_DECLARATION-零申报；
            allowNull: false,
            type: DataTypes.STRING
        },
        accountBook: { //账套信息
            allowNull: true,
            type: DataTypes.JSON
        }
    }, {
        paranoid: false, //假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        tableName: 'accountset',
        validate: {},
        indexes: []
    });
}