const ServiceBase = require("../../sve.base");
const settings = require("./../../../../config/settings");
const System = require("../../../system");
const redisClient = System.getObject("util.redisClient");
const ydz_prefix = "ydz:";

class MessageService extends ServiceBase {
    constructor() {
        super("agriculture", ServiceBase.getDaoName(MessageService));
    }

    async tempMsgProcessing(key, msgContent, time) {
        //APP_TICKET: 每十分钟刷新一次，有效期30分钟
        //TEMP_AUTH_CODE: 企业临时授权码
        const perKey = ydz_prefix + key;
        const addRedisResult = await redisClient.setWithEx(perKey, JSON.stringify(msgContent), time);
        return addRedisResult;
    }
}
module.exports = MessageService;